<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$interval = '15m';
function calculate_hma($klines, $period, $unit) {
    $hma0 = (trader_wma($klines['open'], 3) * 2) - trader_wma($klines['open'], 6);

    $wma_half_period = calculate_wma($klines, (int)($period / 2), $unit);
    $wma_period = calculate_wma($klines, $period, $unit);
    $wma_square_root = calculate_wma($klines, (int)(sqrt($period)), $unit);

    $hma = (($wma_half_period * 2 - $wma_period) + $wma_square_root) / 2;

    return $hma;
}
function array_key_last(array $arr) {
    $i = 0;
    foreach($arr as $key  => $unused) {
        $i = $i +1;
        //return $key;
    }
    return $key;
}
function array_key_first(array $arr) {
    foreach($arr as $key => $unused) {
        return $key;
    }
    return NULL;
}
// Example usage
$json = $apiResponse->getKlines($interval);
$open = [];
$closes = [];
for ($x = 0; $x < count($json); $x++) {
    array_push($open, $json[$x]["open"]);
    array_push($closes, $json[$x]["close"]);
}
$rsi = trader_rsi($closes, 14);
$med = 0;
$div = 0;
$idx = array_key_last($rsi);
$rsihi = 0;
$rsilo = 10000;
$hi = 0;
$lo = 0;
for ($x = $idx -13; $x <= $idx; $x++) {
    $med = $rsi[$x] + $med;
    $div = $div + 1;
    $pep = round($med/$div,3);
    $hi = $rsi[$x] > $rsihi?$x:$hi;
    $lo = $rsi[$x] < $rsilo?$x:$lo;
    $rsihi = $rsi[$x] > $rsihi?$rsi[$x]:$rsihi;
    $rsilo = $rsi[$x] < $rsilo?$rsi[$x]:$rsilo;
    print("rsi:{$rsi[$x]} x:{$x}" .chr(10));
}
if($rsihi < 50){
    print("comprar aquí:" . round($med/$div,3)) . chr(10);
}

print("rsihi:{$rsihi} hi:{$hi}  rsilo:{$rsilo} lo:{$lo} close:{$closes[$hi]}" .chr(10));

//print_r($rsi);
//$actrsi = end($rsi);
//$actrsi = prev($rsi);
//print("rsi:{$actrsi}" . chr(10));

//$hma0 = (trader_wma($open, 3) * 2) - trader_wma($open, 6);
//print($hma0 . chr(10));
$wma3 =  trader_wma($open, 3);
$wma6 =  trader_wma($open, 6);
//print_r($wma3);
//print_r($wma6);
$fKey3 = array_key_first($wma3);
$fKey6 = array_key_first($wma6);
$idx = ($fKey3 >= $fKey6?$fKey3:$fKey6);
print("k3:{$fKey3} k6:{$fKey6} idx:{$idx}" .chr(10));
for ($x = $idx; $x < count($wma3)-1; $x++) {
    $dif  = round($wma3[$x] - $wma6[$x],3);
    print("wma3:{$wma3[$x]} wma6:{$wma6[$x]} dif:{$dif}" .chr(10));
}

?>