<?php
include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
$apiResponse = new ResponseApi($config);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$maorder = [
  'newClientOrderId' => uniqid() . 'LID',
  'side'      => '',
  'quantity'  => '', 
  'workingType' => 'CONTRACT_PRICE',
  'recvWindow' => '5000',
  'symbol'    => (string)$symbol,
  'type'      => 'MARKET',
  'reduceOnly' => 'true',
  //'closePosition'  => 'true'
  
];
// get orders information
function openOrders($apiResponse, $symbol){
  $parameters['symbol'] = 'DOTUSDT';
  $response = $apiResponse->getStopOrder(['symbol'  => $symbol], 0);
  if(count($response) === 0){
    print('***** No hay ordenes abiertas *****' .chr(10));
  }else{
    foreach($response['items'] as $posit)  {
      $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
      print(
        "side':{$posit['side']} " .
        "stopPrice':{$posit['stopPrice']} " .
        "updateTime:{$posit['updateTime']} " .
        "type:{$posit['type']} " .
        chr(10));
    }
  }
}
function compare_two($a, $b)
{
  // sort by time
  $retval = strnatcmp($a['time'], $b['time']);
  // if time are identical, sort by clientOrderId
  if(!$retval) $retval = strnatcmp($a['clientOrderId'], $b['clientOrderId']);
  return $retval;
}
function compare_orderId($a, $b)
{
    return strnatcmp($a['clientOrderId'], $b['clientOrderId']);
}
function allOrders($apiResponse, $symbol){
  $date = (new DateTime('now'));
  $h = 48; //($date)->format('H');
  $m = ($date)->format('i');
  $tosub = new DateInterval('PT' . $h .'H' . $m . 'M'); // xH
  $date->sub($tosub);
  $from =  strtotime($date->format("Y-m-d H:i:s")) * 1000;
  $response = $apiResponse->getListOrder(['symbol' => $symbol], 0);
  usort($response, 'compare_two');
  $allmarket = array();
  foreach($response as $posit)  {
    $timems = $posit['time'];
    if($timems > $from){
      if ($posit['origType'] === "MARKET"){
        $posit['price'] = $posit['avgPrice'];
      }else{
        $posit['price'] = $posit['stopPrice'];
      } 
      if($posit['origType'] === 'MARKET'){
        $allmarket[] = $posit;
      }
    }  
  }
  foreach($allmarket as $posit)  {
    $posit['time'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['time'])/1000)))->format('Y-m-d H:i:s');
    $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
    print('time: ' . $posit['time'] . '|orderId: ' . $posit['clientOrderId'] . ' |status: ' . $posit['status'] .  '|price: ' . $posit['price'] . '|origQty: ' . 
    $posit['origQty'] .  '|type: ' . $posit['type'] .  '|side: ' . $posit['side'] .  '|origType: ' . $posit['origType'] . 
     chr(10));
  }
  print("**************** end *****************" .chr(10));
  $posit =  end($allmarket);
  $result = [
    "clientOrderId" => $posit['clientOrderId'],
    "side" => $posit['side'],
    "qty" => (string)$posit['origQty']
  ];
  $posit['time'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['time'])/1000)))->format('Y-m-d H:i:s');
  $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
  print('time: ' . $posit['time'] . '|orderId: ' . $posit['clientOrderId'] . ' |status: ' . $posit['status'] .  '|price: ' . $posit['price'] . '|origQty: ' . 
  $posit['origQty'] .  '|type: ' . $posit['type'] .  '|side: ' . $posit['side'] .  '|origType: ' . $posit['origType'] . 
   chr(10));
  /*
  foreach($response as $posit)  {
    $timems = $posit['time'];
    if($timems > $from){
      if ($posit['origType'] === "MARKET"){
        $posit['price'] = $posit['avgPrice'];
      }else{
        $posit['price'] = $posit['stopPrice'];
      } 
      if($posit['origType'] === 'MARKET'){
        $posit['time'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['time'])/1000)))->format('Y-m-d H:i:s');
        $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');
        print('time: ' . $posit['time'] . '|orderId: ' . $posit['clientOrderId'] . ' |status: ' . $posit['status'] .  '|price: ' . $posit['price'] . '|origQty: ' . 
        $posit['origQty'] .  '|type: ' . $posit['type'] .  '|side: ' . $posit['side'] .  '|origType: ' . $posit['origType'] . 
         chr(10));
      }

    }
  }*/
  return $result;
}
function getPosition($apiResponse, $symbol){
  $response = $apiResponse->getAccount(['symbol' => $symbol]);
  foreach($response['positions'] as $posit)  {
      if($posit['symbol'] === "DOTUSDT"){
        $date = $posit['updateTime'];
        $posit['updateTime'] = (new DateTime(date('m/d/Y H:i:s',intval($posit['updateTime'])/1000)))->format('Y-m-d H:i:s');      
        print_r($posit);
        print(chr(10));
        print("symbol:" . $posit['symbol'] . " | updateTime:" . $posit['updateTime'] . " | entryPrice:" . $posit['entryPrice'] . " | leverage:" . 
              $posit['leverage'] . " | entryPrice:" . $posit['entryPrice'] . " | notional:" . $posit['notional'] . chr(10));
        //print(chr(10));
      }
  }
  return $date;
}

function getStatus($apiResponse,$symbol){
  $status = 0;
  $times = 0;
  $initialm = 0;
  $breakEvenPrice = 0;
  while(true){
      $result = $apiResponse->getAccount(['symbol' => $symbol], $times);
      if (array_key_exists("totalInitialMargin", $result)) {
          $positions = $result['positions'];
          $balance  = floatval($result['availableBalance']);
          foreach($positions as $posit)  {
              if($posit['symbol'] === $symbol){
                  if(floatval($posit['initialMargin']) > 0){
                      $status = 1;
                      $initialm = floatval($posit['initialMargin']);
                      $breakEvenPrice = $posit['breakEvenPrice'];
                  }                
              }
          }                             
          break;
      }else{
          $times = $times + 1;
          if ($times > 5){
              $status = 0;
              $initialm = 0;
              break;
          }
      }
  }
  return "Status:{$status}, initialMargin:{$initialm}, Balance:{$balance}, BreakEvenPrice:{$breakEvenPrice}";
}
// **************************** para ejecutar procesos desde de aqui *****************************************
/*
$time = sendRequest('GET', 'api/v3/time', 'api');
$timedif = $time['serverTime'] - round(microtime(true) * 1000);
$timestamp = round(microtime(true) * 1000) + $timedif;
$timep = (new DateTime(date('m/d/Y H:i:s',intval($time['serverTime'])/1000)))->format('Y-m-d H:i:s');
$timesp = (new DateTime(date('m/d/Y H:i:s',intval($timestamp)/1000)))->format('Y-m-d H:i:s');
print("time: " . $timep . chr(10));
print("timedif " . $timedif . chr(10));
print("timestamp " . $timesp . chr(10));
*/
$date = (new DateTime('now'));
print('***** Ahora:' . $date->format('Y-m-d H:i:s') . '*****' .chr(10));
print("---- openOrders ----" . chr(10));
openOrders($apiResponse, $symbol);
print("---- positions ----" . chr(10));
$date = getPosition($apiResponse, $symbol);
print("---- allOrders ----" . chr(10));
$dataorder = allOrders($apiResponse, $symbol);
$maorder['newClientOrderId'] = $dataorder["clientOrderId"] . "D";
$maorder['side'] = $dataorder["side"] === "BUY"?"SELL":"BUY";
$maorder['quantity'] = $dataorder["qty"];
var_dump($maorder);
var_dump($dataorder);
print("---- status ----" .chr(10));
$status = getStatus($apiResponse,$symbol, 'USDT');
print($status . chr(10));
 // **************************** para ejecutar procesos hasta de aqui *****************************************


