<?php
namespace App;
use Ratchet\Client\Connector as RatchetConnector;
use Ratchet\Client\WebSocket;
use Ratchet\RFC6455\Messaging\MessageInterface;
use React\EventLoop\Factory;
use React\EventLoop\LoopInterface;
use React\Socket\Connector as SocketConnector;
use App\ValidResponse;
use App\FuTrperm;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
class WebSocketApi
{
    protected $calcvaria = true; 
    protected $camsm = 0;
    protected $wslocparams = [];
    protected $i = 0;
    protected static $isDebugMode = false;
    protected $client;
    protected $fstream = 'wss://fstream.binance.com/ws/';
    protected $gstream = 'wss://ws-api.binance.com/ws-api/v3/';
    protected static $config = [
        'base_uri'        => 'https://fapi.binance.com/', 
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => true,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];
    /** @var LoopInterface */
    protected $loop;    
    /**
     * @var FuTrperm  $auth
    */
    protected $auth;
    /**
     * @var ValidResponse  $validresponse
    */
    protected $validresponse;
    /**
     * @var array
     */
    protected $headers = [];
    const METHOD_PUT = 'PUT';
    const METHOD_GET = 'GET';
    const METHOD_POST = 'POST';
    const METHOD_DELETE = 'DELETE';
    private function buildQuery($params = [])
    {
        $new_arr = array();
        $query_add = '';
        foreach ($params as $label=>$item) {
            if ( gettype($item) == 'array' ) {
                foreach ($item as $arritem) {
                    $query_add = $label . '=' . $arritem . '&' . $query_add;
                }
            } else {
                $new_arr[$label] = $item;
            }
        }
        $query = http_build_query($new_arr, '', '&');
        $query = $query_add . $query;
        return $query;
    } 
    private function getClient(array $config)
    {
        $key = md5(json_encode($config));
        if (isset($clients[$key])) {
            return $clients[$key];
        }
        $clients[$key] = new Client($config);
        return $clients[$key];
    }
    private function getPrice($symbol)
    {
        $params = ['symbol' => $symbol];
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/ticker/price', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        } 
    }
    private function cancelOrderById($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/order', self::METHOD_DELETE, $params);
            $result = $this->client->request(self::METHOD_DELETE, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
    }
    private function createOrder($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/order', self::METHOD_POST, $params);
            $result = $this->client->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog('>>>>>:' . $exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    private function delOneOrder($symbol, $orderid){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->cancelOrderById(['symbol' => $symbol, 'orderId' => $orderid],$times);
            if (array_key_exists("status", $result)) {
                $times = 0;
                while(true){
                    if ($result['status'] === 'CANCELED'){
                        $resp = true;
                        break;
                    }else{
                        sleep(5);
                        $times = $times + 1;
                        if ($times > 5){
                            $rep = false; 
                            break;
                        }                      
                    }
                }
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $resp = false; 
                    break;
                }                
            }
        }
        return $resp;
    } 
    private function createSlOrder($slorder, $slprice, $incr, $CV){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->createOrder($slorder, $times);
            if (array_key_exists("orderId", $result)) {
                $this->slOrderId = $result['orderId'];
                $resp = true;
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $resp = false;
                    break;
                }
                if (array_key_exists("code", $result)) {
                    if($result['code'] === -2021){
                        if($CV === 1){
                            $slorder['stopPrice'] = $slorder['stopPrice'] - $incr;
                        }else{
                            $slorder['stopPrice'] = $slorder['stopPrice'] + $incr;
                        }
                        if(($CV === 1 and $slorder['stopPrice'] <= $slprice) or ($CV === 2 and $slorder['stopPrice'] >= $slprice)){
                            $resp = false; 
                            break;
                        }                        
                    }
                }              
            }
        }
        return $resp;
    }
    private function slProtected(){
        $respocal = false;
        $this->camsm = 0;
        $slorder = $this->wslocparams['slorder'];
        $symbol = $this->wslocparams['symbol'];
        $this->wslocparams['camsm'] = 0;
        $CV = $this->wslocparams['CV'];
        $action = $CV = 1?'Compras':'Ventas';
        $slorder['stopPrice'] = $this->wslocparams['maeprice'];
        $incr = ($this->wslocparams['maeprice'] - $this->wslocparams['slprice']) / 5;
        $createsl = $this->createSlOrder($slorder, $this->wslocparams['slprice'], $incr, $CV);
        if($createsl){
            $this->wslocparams["porSm"] = 0;
            $this->wslocparams['impSm'] = $this->wslocparams['maeprice'];
            $this->wslocparams['camsm'] = 1;
            $this->camsm = 1;
            $this->wslocparams['isprice'] = true;
            $respocal = true;
            $this->printLog("cambio a: {$slorder['stopPrice']} en {$action}" . chr(10));
            $respDel = $this->delOneOrder($symbol,  $this->wslocparams['orderid']);
        }else{
            $this->printLog("No se pudo crear sl protegido" . chr(10));   
            $this->wslocparams['camsm'] = 2;
            $this->camsm = 2;         
        }
        return $respocal;
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( $date . ": " . $from );
    }
    public function __construct($config = [])
    {
        $this->auth = new FuTrperm($config);
        $this->validresponse = new ValidResponse();
        $this->client = $this->getClient(static::$config);
    }
    /**
     * Get the event loop instance, default return Factory::create()
     * @return LoopInterface
     */    
    public function getLoop()
    {
        if ($this->loop === null) {
            $this->loop = Factory::create();
        }
        return $this->loop;
    }

    /**
     * Set the event loop instance
     * @param LoopInterface $loop
     */
    public function setLoop(LoopInterface $loop)
    {
        $this->loop = $loop;
    }

    /**
     * Subscribe multiple channels by url
     * @param array $wsrequest
     * @param array $channels
     * @param callable $onmessage
     * @param callable|null $onClose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function cntlOrders(array $wsrequest,  callable $onmessage, callable $onClose = null)
    {
        $options = [];
        if (!isset($options['tls']['verify_peer'])) {
            $options['tls']['verify_peer'] = true;
        }
        $this->wslocparams = $wsrequest;
        $loop = $this->getLoop();
        $reactConnector = new SocketConnector($loop, $options);
        $timer = $this->wslocparams['pingInterval'];
        $this->wslocparams['connectUrl'] = $this->fstream . $this->wslocparams['listenKey'];
        $date = new \DateTime('now');
        print("UTC: " . $date->format('Y-m-d H:i:s') . chr(10));

        $loop->addPeriodicTimer($timer, function () {
            /*
            if($this->calcvaria){
                $CV = $this->wslocparams['CV'];
                $resprice = $this->getPrice($this->wslocparams['symbol']);
                $pricenow = $resprice['price'];
                $maeprice = $this->wslocparams['maeprice'];
                if($CV === 1){
                    $preope = round($maeprice -  (($maeprice * $this->wslocparams['porsm']) / 100),3);
                }else{
                    $preope = round($maeprice +  (($maeprice * $this->wslocparams['porsm']) / 100),3);
                }
                if(($CV === 1 and $pricenow >= $preope) or ($CV === 2 and $pricenow <= $preope)){
                    $this->calcvaria = false;
                    $action = $CV = 1?'Compras':'Ventas';
                    $this->printLog($action. ' - priceNow:' . $pricenow . ' preOpe:' . $preope .chr(10)); 
                    $rescalcv = $this->slProtected();
                    $this->wslocparams['camsm'] = $this->camsm;
                }
            }
            */
            $listenKey = $this->wslocparams['listenKey'];
            $this->headers = $this->auth->getHeaders();
            try{
                /*
                if ($this->wslocparams['countup']  >= 1800){
                    $this->wslocparams['countup'] = 0;
                    $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                    $result = $this->client->request(self::METHOD_PUT, $url, [
                        'headers' => $this->headers
                    ]);
                    $datakey = $this->validresponse->getApiData(true, $result);
                }else{
                    $this->wslocparams['countup'] = $this->wslocparams['countup'] + 3;
                }
                */
                $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                $result = $this->client->request(self::METHOD_PUT, $url, [
                    'headers' => $this->headers
                ]);
                $datakey = $this->validresponse->getApiData(true, $result);
            } catch (RequestException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
                return $message;
            } catch (ResponseApiException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
            }                 
        });
        $connector = new RatchetConnector($loop, $reactConnector);
        /**
         * @var \Exception|\Throwable $exception
         */
        $exception = null;
        $connector($this->wslocparams['connectUrl'])->then(function (WebSocket $ws) use ($onmessage, $onClose, $loop) {
            $ws->on('message', function ($data) use ($ws, $onmessage, $loop) {
                $msgarray = json_decode($data, true);
                call_user_func($onmessage, $msgarray, $ws, $loop, $this->camsm);
            });
            $ws->on('close', function ($code = null, $reason = null) use ($loop) {
                // WPCS: XSS OK.
                echo "userData: WebSocket Connection closed! ({$code} - {$reason})" . PHP_EOL;
                $loop->stop();
            });
            $ws->on('ping', function ($data) use ($ws, $loop) {
                print( "userData: WebSocket Send Ping! - Start" . PHP_EOL);
                $date = new \DateTime('now');
                print("UTC: " . $date->format('Y-m-d H:i:s') . chr(10));
                $msgarray = json_decode($data, true);
                print_r($data);
                print( "userData: WebSocket Send Ping! - End" . PHP_EOL);
                $pong = $this->createPongMessage();
                $pongStr = json_encode($pong);
                // fputs(STDIN, print_r($ping, true));
                $ws->send($pongStr);
            });
        }, function ($e) use ($loop) {
            // WPCS: XSS OK.
            echo "userData: Could not connect: {$e->getMessage()}" . PHP_EOL;
            $loop->stop();
        });
        $loop->run();
        if ($exception !== null) {
            throw $exception;
            print_r($exception);
        }
    }
    public function getWsMessage(array $wsrequest,  callable $onmessage, callable $onClose = null)
    {
        $options = [];
        $this->wslocparams = $wsrequest;
        if (!isset($options['tls']['verify_peer'])) {
            $options['tls']['verify_peer'] = true;
        }
        $loop = $this->getLoop();
        $reactConnector = new SocketConnector($loop, $options);
        $timer = 1800;

        $loop->addPeriodicTimer($timer, function () {
            $listenKey = $this->wslocparams['listenKey'];
            $this->headers = $this->auth->getHeaders();
            try{
                $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                $result = $this->client->request(self::METHOD_PUT, $url, [
                    'headers' => $this->headers
                ]);
                $datakey = $this->validresponse->getApiData(true, $result);
            } catch (RequestException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
                return $message;
            } catch (ResponseApiException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
            }                 
        });
        $connector = new RatchetConnector($loop, $reactConnector);
        /**
         * @var \Exception|\Throwable $exception
         */
        $exception = null;
        $connector($this->wslocparams['connectUrl'])->then(function (WebSocket $ws) use ($onmessage, $onClose, $loop) {

            $ws->on('message', function ($data) use ($ws, $onmessage, $loop) {
                $msgarray = json_decode($data, true);
                call_user_func($onmessage, $msgarray, $ws, $loop, $this->wslocparams);
            });
            $ws->on('close', function ($code = null, $reason = null) use ($loop) {
                // WPCS: XSS OK.
                echo "userData: WebSocket Connection closed! ({$code} - {$reason})" . PHP_EOL;
                $loop->stop();
            });
        }, function ($e) use ($loop) {
            // WPCS: XSS OK.
            echo "userData: Could not connect: {$e->getMessage()}" . PHP_EOL;
            $loop->stop();
        });
        $loop->run();
        if ($exception !== null) {
            throw $exception;
        }
    }
    /**
     * Subscribe multiple public channels
     * @param array $channels
     * @param callable $onmessage
     * @param callable|null $onClose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribePublicChannels($wsrequest,  callable $onmessage, callable $onClose = null, array $options = [])
    {
        $this->cntlOrders($wsrequest,  $onmessage, $onClose, $options);
    }

    /**
     * Subscribe multiple private channels
     * @param callable $onmessage
     * @param callable|null $onClose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribePrivateChannels($wsrequest,  callable $onmessage, callable $onClose = null)
    {
        $this->cntlOrders($wsrequest,  $onmessage, $onClose);
    }


    /**
     * Create a ping message
     * @param string $id
     * @return array
     */
    public function createPingMessage($id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'ping'];
    }
    public function createPongMessage($id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'pong'];
    }
    /**
     * Create a subscription message
     * @param string $topic
     * @param bool $privateChannel
     * @param bool $response
     * @param string $id
     * @return array
     */
    public function createSubscribeMessage($topic, $privateChannel = false, $response = true, $id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'subscribe', 'topic' => $topic, 'privateChannel' => $privateChannel, 'response' => $response];
    }

    /**
     * Create an unsubscribe message
     * @param string $topic
     * @param bool $privateChannel
     * @param bool $response
     * @param string $id
     * @return array
     */
    public function createUnsubscribeMessage($topic, $privateChannel = false, $response = true, $id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'unsubscribe', 'topic' => $topic, 'privateChannel' => $privateChannel, 'response' => $response];
    }
}
