<?php
namespace App;
use Ratchet\Client\Connector as RatchetConnector;
use Ratchet\Client\WebSocket;
use Ratchet\RFC6455\Messaging\MessageInterface;
use React\EventLoop\Factory;
use React\EventLoop\LoopInterface;
use React\Socket\Connector as SocketConnector;
use App\ValidResponse;
use App\FuTrperm;
use App\RsiMacdClosePos;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
class WebSocketApi
{
    protected $snifer = true; 
    protected $progre = false; 
    protected $contin = true;
    protected $wslocparams = [];
    protected $lconfig = [];
    protected $snifpar = [];
    protected $maorder;
    protected $i = 0;
    protected static $isDebugMode = false;
    protected $client;
    protected $inact = 0;
    protected $breakevenprice = 0;
    protected $CV;
    protected $repeat = 0;
    protected $fstream = 'wss://fstream.binance.com/ws/';
    protected $gstream = 'wss://ws-api.binance.com/ws-api/v3/';
    protected static $configcli = [
        'base_uri'        => 'https://fapi.binance.com/', 
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => true,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];
    /** @var LoopInterface */
    protected $loop;    
    /**
     * @var FuTrperm  $auth
    */
    protected $auth;
    /**
     * @var ValidResponse  $validresponse
    */
    protected $validresponse;
    /**
     * @var array
     */
    /**
     * @var WebSocket  $wsn
    */
    protected $wsn;
    /**
    * @var RsiMacdClosePos
    */
    protected $rsiMacdClosePos; 
    protected $headers = [];
    const METHOD_PUT = 'PUT';
    const METHOD_GET = 'GET';
    const METHOD_POST = 'POST';
    const METHOD_DELETE = 'DELETE';
    private function getClient(array $config)
    {
        $key = md5(json_encode($config));
        if (isset($clients[$key])) {
            return $clients[$key];
        }
        $clients[$key] = new Client($config);
        return $clients[$key];
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( $date . ": " . $from );
    }
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $this->lconfig = $params->settings['config'];     
        $symbol = $this->lconfig['symbol'];
        $this->auth = new FuTrperm();
        $this->validresponse = new ValidResponse();
        $this->client = $this->getClient(static::$configcli);
        $this->rsiMacdClosePos = new RsiMacdClosePos();

    }
    /**
     * Get the event loop instance, default return Factory::create()
     * @return LoopInterface
     */    
    public function getLoop()
    {
        if ($this->loop === null) {
            $this->loop = Factory::create();
        }
        return $this->loop;
    }

    /**
     * Set the event loop instance
     * @param LoopInterface $loop
     */
    public function setLoop(LoopInterface $loop)
    {
        $this->loop = $loop;
    }

    /**
     * Subscribe multiple channels by url
     * @param array $wsrequest
     * @param array $channels
     * @param callable $onmessage
     * @param callable|null $onclose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function cntlOrdersOrg(array $wsrequest,  callable $onmessage, callable $onclose = null)
    {
        $options = [];
        if (!isset($options['tls']['verify_peer'])) {
            $options['tls']['verify_peer'] = true;
        }
        $this->wslocparams = $wsrequest;
        $this->maorder = $wsrequest['maorder'];
        $loop = $this->getLoop();
        $reactConnector = new SocketConnector($loop, $options);
        $timer = $this->wslocparams['pingInterval'];
        $this->wslocparams['connectUrl'] = $this->fstream . $this->wslocparams['listenKey'];
        $loop->addPeriodicTimer($timer, function () {
            $listenKey = $this->wslocparams['listenKey'];
            $this->headers = $this->auth->getHeaders();
            try{
                $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                $result = $this->client->request(self::METHOD_PUT, $url, [
                    'headers' => $this->headers
                ]);
                $datakey = $this->validresponse->getApiData(true, $result);
            } catch (RequestException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
                return $message;
            } catch (ResponseApiException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
            }                 
        });
        $connector = new RatchetConnector($loop, $reactConnector);
        /**
         * @var \Exception|\Throwable $exception
         */
        $exception = null;
        $connector($this->wslocparams['connectUrl'])->then(function (WebSocket $ws) use ($onmessage, $onclose, $loop) {
            $ws->on('message', function ($data) use ($ws, $onmessage, $loop) {
                $msgarray = json_decode($data, true);
                call_user_func($onmessage, $msgarray, $ws, $loop);
            });
            $ws->on('close', function ($code = null, $reason = null) use ($onclose, $loop) {
                if($code !== 1616 and $code !== 2424){
                    $reason = "userData: WebSocket Connection closed! - {$reason})";
                }
                $msgarray = [
                    'code'   => $code, 
                    'reason' => $reason
                ];
                call_user_func($onclose, $msgarray, $loop);
            });
        }, function (WebSocket $ws, $e) use ($onclose,$loop) {
            print("Start:error in WebSocket" .chr(10));
            print_r($e);
            print("End:error in WebSocket" .chr(10));
            $msgres = "userData: Could not connect: {$e->getMessage()}";
            $ws->close(1616, $msgres);
        });
        $loop->run();
        if ($exception !== null) {
            throw $exception;
        }
    }
    public function cntlOrders(array $wsrequest,  callable $onmessage, callable $onclose = null)
    {
        $options = [];
        if (!isset($options['tls']['verify_peer'])) {
            $options['tls']['verify_peer'] = true;
        }
        $this->wslocparams = $wsrequest;
        $this->maorder = $wsrequest['maorder'];
        $this->inact = $wsrequest['inact'];
        $this->breakevenprice = $wsrequest['breakevenprice'];
        $this->CV = $wsrequest['CV'];
        $this->contin = true;
        $this->snifer = $this->lconfig['sniferws'];
        $this->proge = $this->lconfig['proge'];
        $loop = $this->getLoop();
        $reactConnector = new SocketConnector($loop, $options);
        if($this->snifer){
            $timer =  10;
            $this->snifpar = [
                'maorder' => $this->maorder,
                'beprice' => $this->breakevenprice,
                'inact' => $this->inact,
                'cv' => $this->CV,
                'repeat' => $this->repeat,
                'proge' => $this->proge
            ];
        }else{
            $timer = $this->wslocparams['pingInterval'];
        }
        $this->wslocparams['connectUrl'] = $this->fstream . $this->wslocparams['listenKey'];
        $loop->addPeriodicTimer($timer, function () {
            if($this->snifer){
                if($this->contin){
                    $resp = $this->rsiMacdClosePos->calcRsiMacd($this->snifpar);
                    $this->repeat = $this->repeat + 1;
                    //print("repeat:{$this->repeat} continua:{$this->contin}" .chr(10));
                    if($resp['resp']){
                        $this->contin = false;
                        $this->repeat = 0;
                        //$this->wsn->close(2206, "parar, por cierre:" . $resp['closep']);
                    }
                }

            }
            $listenKey = $this->wslocparams['listenKey'];
            $this->headers = $this->auth->getHeaders();
            try{
                if($this->snifer){
                    if ($this->wslocparams['countup']  >= 1800){
                        $this->wslocparams['countup'] = 0;
                        $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                        $result = $this->client->request(self::METHOD_PUT, $url, [
                            'headers' => $this->headers
                        ]);
                        $datakey = $this->validresponse->getApiData(true, $result);
                    }else{
                        $this->wslocparams['countup'] = $this->wslocparams['countup'] + 10;
                    }
                }else{
                    $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                    $result = $this->client->request(self::METHOD_PUT, $url, [
                        'headers' => $this->headers
                    ]);
                    $datakey = $this->validresponse->getApiData(true, $result);
                }



            } catch (RequestException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
                return $message;
            } catch (ResponseApiException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
            }                 
        });
        $connector = new RatchetConnector($loop, $reactConnector);
        /**
         * @var \Exception|\Throwable $exception
         */
        $exception = null;
        $connector($this->wslocparams['connectUrl'])->then(function (WebSocket $ws) use ($onmessage, $onclose, $loop) {
            $this->wsn = $ws;
            $ws->on('message', function ($data) use ($ws, $onmessage, $loop) {
                $msgarray = json_decode($data, true);
                call_user_func($onmessage, $msgarray, $ws, $loop);
            });
            $ws->on('close', function ($code = null, $reason = null) use ($onclose, $loop) {
                if($code !== 1616 and $code !== 2424 and $code !== 2206){
                    $reason = "userData: WebSocket Connection closed! - {$reason})";
                }
                $msgarray = [
                    'code'   => $code, 
                    'reason' => $reason
                ];
                if($code === 2206){
                    $loop->stop();
                }
                call_user_func($onclose, $msgarray, $loop);
            });
        }, function (WebSocket $ws, $e) use ($onclose,$loop) {
            print("Start:error in WebSocket" .chr(10));
            print_r($e);
            print("End:error in WebSocket" .chr(10));
            $msgres = "userData: Could not connect: {$e->getMessage()}";
            $ws->close(1616, $msgres);
        });
        $loop->run();
        if ($exception !== null) {
            throw $exception;
        }
    }
    public function getWsMessage(array $wsrequest,  callable $onmessage, callable $onclose = null)
    {
        $options = [];
        $this->wslocparams = $wsrequest;
        if (!isset($options['tls']['verify_peer'])) {
            $options['tls']['verify_peer'] = true;
        }
        $loop = $this->getLoop();
        $reactConnector = new SocketConnector($loop, $options);
        $timer = 10; //1800;
        $firststop = 0;
        $loop->addPeriodicTimer($timer, function () {
            $listenKey = $this->wslocparams['listenKey'];
            $this->headers = $this->auth->getHeaders();
            try{
                $url = $this->auth->signature("/fapi/v1/listenKey", self::METHOD_PUT, []); 
                $result = $this->client->request(self::METHOD_PUT, $url, [
                    'headers' => $this->headers
                ]);
                $firststop = 1;
                print("firststop:{$firststop}" .chr(10));
                if ($firststop === 1){
                    $this->wsn->close(1616, "parar por cambio en rsi");
                }
                $datakey = $this->validresponse->getApiData(true, $result);
            } catch (RequestException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
                return $message;
            } catch (ResponseApiException $exp) {
                $this->printLog($exp->getMessage() .chr(10));
                return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
            }                 
        });
        $connector = new RatchetConnector($loop, $reactConnector);
        /**
         * @var \Exception|\Throwable $exception
         */
        $exception = null;
        $connector($this->wslocparams['connectUrl'])->then(function (WebSocket $ws) use ($onmessage, $onclose, $loop,$firststop) {
            $this->wsn = $ws;
            print("en connector:{$firststop}" .chr(10));
            $ws->on('message', function ($data) use ($ws, $onmessage, $loop) {
                $msgarray = json_decode($data, true);
                call_user_func($onmessage, $msgarray, $ws, $loop, $this->wslocparams);
            });
            $ws->on('close', function ($code = null, $reason = null) use ($onclose, $loop, $ws) {
                // WPCS: XSS OK.
                print("onclose" .chr(10));
                if($code !== 1616 and $code !== 2424){
                    $reason = "userData: WebSocket Connection closed! - {$reason})";
                }
                $msgarray = [
                    'code' => $code,
                    'reason' =>  $reason
                ];
                call_user_func($onclose, $msgarray, $loop);
            });
        }, function (WebSocket $ws, $e) use ($onclose, $loop) {
            $msgres = "userData: Could not connect: {$e->getMessage()}" . PHP_EOL;
            $ws->close(1616, $msgres);
        });
        if ($exception !== null) {
            print("ex forzada:{$exception}");
            $loop->stop();
            $this->wsn->close(1616, "ex forzada:{$exception}");
        }
        $loop->run();


    }
    /**
     * Subscribe multiple public channels
     * @param array $channels
     * @param callable $onmessage
     * @param callable|null $onclose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribePublicChannels($wsrequest,  callable $onmessage, callable $onclose = null, array $options = [])
    {
        $this->cntlOrders($wsrequest,  $onmessage, $onclose, $options);
    }

    /**
     * Subscribe multiple private channels
     * @param callable $onmessage
     * @param callable|null $onclose
     * @param array $options
     * @throws \Exception|\Throwable
     */
    public function subscribePrivateChannels($wsrequest,  callable $onmessage, callable $onclose = null)
    {
        $this->cntlOrders($wsrequest,  $onmessage, $onclose);
    }


    /**
     * Create a ping message
     * @param string $id
     * @return array
     */
    public function createPingMessage($id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'ping'];
    }

    /**
     * Create a subscription message
     * @param string $topic
     * @param bool $privateChannel
     * @param bool $response
     * @param string $id
     * @return array
     */
    public function createSubscribeMessage($topic, $privateChannel = false, $response = true, $id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'subscribe', 'topic' => $topic, 'privateChannel' => $privateChannel, 'response' => $response];
    }

    /**
     * Create an unsubscribe message
     * @param string $topic
     * @param bool $privateChannel
     * @param bool $response
     * @param string $id
     * @return array
     */
    public function createUnsubscribeMessage($topic, $privateChannel = false, $response = true, $id = null)
    {
        return ['id' => $id ?: uniqid('', true), 'type' => 'unsubscribe', 'topic' => $topic, 'privateChannel' => $privateChannel, 'response' => $response];
    }
}
