<?php

namespace App;

class FuTrperm
{
    private $apiKey;
    private $apiKeyTest;

    private $privateKey;
    private $apiSecretTest;
    private $passwd;

    private $apiKeyVersion;

    const API_KEY_VERSION_V1 = '1';

    const API_KEY_VERSION_V2 = '2';

    public function __construct($apiKeyVersion = self::API_KEY_VERSION_V1)
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];
        $this->apiKey = $config['apikey']; 
        $this->privateKey =  $config['private'];
        $this->apiKeyVersion = $apiKeyVersion;
    }
    private function buildQuery($params = [])
    {
        $new_arr = array();
        $query_add = '';
        foreach ($params as $label=>$item) {
            if ( gettype($item) == 'array' ) {
                foreach ($item as $arritem) {
                    $query_add = $label . '=' . $arritem . '&' . $query_add;
                }
            } else {
                $new_arr[$label] = $item;
            }
        }
        $query = http_build_query($new_arr, '', '&');
        $query = $query_add . $query;
    
        return $query;
    } 
    function signatureGen($path, $method, $parameters = []) {
        $parameters['timestamp'] = round(microtime(true) * 1000);
        $query = $this->buildQuery($parameters);
        $signature = hash_hmac('sha256', $query, $this->apiSecretTest);
        return "${path}?${query}&signature=${signature}";
    }
    private function signatureRSA($data) {
        $pkeyid = openssl_pkey_get_private($this->privateKey); 
        openssl_sign($data, $signature, $pkeyid, 'RSA-SHA256');
        openssl_free_key($pkeyid);
        return $signature;
    }
    public function signature($path, $method, $parameters = []) {
        $parameters['timestamp'] = round(microtime(true) * 1000);
        $query = $this->buildQuery($parameters);
        $signatureRSA = urlencode(base64_encode($this->signatureRSA($query)));
        return "${path}?${query}&signature=${signatureRSA}";
    }
    public function signatureBase($parameters = []) {
        $parameters['timestamp'] = round(microtime(true) * 1000);
        $query = $this->buildQuery($parameters);
        $signatureRSA = base64_encode($this->signatureRSA($query));
        return $signatureRSA;
    } 
    public function getHeaders()
    {
        $headers = [
            'X-MBX-APIKEY' => $this->apiKey,
            'User-Agent' => 'Mozilla/4.0 (compatible; PHP Binance API)',
            'Content-Type' => 'application/json'
        ];
        return $headers;
    }
    public function getTestHeaders()
    {
        $headers = [
            'X-MBX-APIKEY' => $this->apiKeyTest,
            'User-Agent' => 'Mozilla/4.0 (compatible; PHP Binance API)',
            'Content-Type' => 'application/json'
        ];
        return $headers;
    }
}