<?php
namespace App;
use App\ApiPositionRes;
class CancelPosition 
{
    /**
     * @var ResponseApi
     */
    protected $apiPositionRes;
     /**
     * @var OneMaOrder
     */
    protected $oneMaOrder;  
    protected $symbol = '';
    protected $currency = '';
    protected $maorder = [];
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];
        $this->apiPositionRes = new ApiPositionRes();
        $this->symbol = $config['symbol'];  
    }
    private function createMaOrderForDel(){
        $times = 0;
        while(true){
            $result = $this->apiPositionRes->createOrder($this->maorder, $times);
            if (array_key_exists("orderId", $result)) {
                break;
            }else{
                $times = $times + 1;
                if (array_key_exists("code", $result)) {
                    if($result['code'] === -2019 or $result['code'] === -2022 or $result['code'] === -1102){
                        if($this->maorder['quantity'] <= 0.8){
                            $this->sendAlert(6, 'FALSE', 'FALSE');
                            $this->retval['doit'] = 0;  
                            break;
                        }else{
                            $this->maorder['quantity'] = round($this->maorder['quantity'] - 0.1,1);
                            $this->printLog('crear maorder for del - update qty:' . $this->maorder['quantity'] . chr(10));
                            break;
                        }

                    }else{
                        if ($times > 5){
                            $this->sendAlert(3, 'FALSE', 'FALSE');
                            $this->retval['doit'] = 0;  
                            break;
                        }
                    }
                }else{
                    if ($times > 5){
                        //$this->printLog('error - crear maorder for del' .chr(10));
                        $this->sendAlert(3, 'FALSE', 'FALSE');
                        $this->retval['doit'] = 0;  
                        break;
                    }

                }
            }
        }
        return $times;
    }
    // Ignore maorder, get from position  *** Start ***
    private function openOrders(){
        $parameters['symbol'] = 'DOTUSDT';
        $response = $this->apiPositionRes->getStopOrder(['symbol'  => $this->symbol], 0);
        if(count($response['items']) === 0){
            print('***** No hay ordenes abiertas *****' .chr(10));
        }
    }
    private function compare_two($a, $b)
    {
        // sort by time
        $retval = strnatcmp($a['time'], $b['time']);
        // if time are identical, sort by clientOrderId
        if(!$retval) $retval = strnatcmp($a['clientOrderId'], $b['clientOrderId']);
        return $retval;
    }
    private function compare_orderId($a, $b)
    {
        return strnatcmp($a['clientOrderId'], $b['clientOrderId']);
    }
    private function allOrders(){
        $date = (new \DateTime('now'));
        $h = 48; //($date)->format('H');
        $m = ($date)->format('i');
        $tosub = new \DateInterval('PT' . $h .'H' . $m . 'M'); // xH
        $date->sub($tosub);
        $from =  strtotime($date->format("Y-m-d H:i:s")) * 1000;
        $response = $this->apiPositionRes->getListOrder(['symbol' => $this->symbol], 0);
        usort($response, array( $this, 'compare_two'));
        $allmarket = array();
        foreach($response as $posit)  {
            $timems = $posit['time'];
            if($timems > $from){
                if ($posit['origType'] === "MARKET"){
                    $posit['price'] = $posit['avgPrice'];
                }else{
                    $posit['price'] = $posit['stopPrice'];
                } 
                if($posit['origType'] === 'MARKET'){
                    $allmarket[] = $posit;
                }
            }  
        }

        $posit =  end($allmarket);
        $result = [
            "clientOrderId" => $posit['clientOrderId'],
            "side" => $posit['side'],
            "qty" => (string)$posit['origQty']
        ];
        return $result;
    }
    // Ignore maorder, get from position  *** End ***   
    private function delAllOrders($init){
        $times = 0;
        $alldel = false;
        if($init){
            $result = $this->createMaOrderForDel();
            unset($this->maorder['reduceOnly']);
        }
        while(true){
            $result = $this->apiPositionRes->cancelAllOrders(['symbol' => $this->symbol],$times);
            if (array_key_exists("code", $result) and $result['code'] === 200) {
                $alldel = true;
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $alldel = false;
                    break;
                } 
            }
        }
        return $alldel;
    }
    private function delMaeOrder(){
        $result = $this->createMaOrderForDel();
        unset($this->maorder['reduceOnly']); 
        return $result;       
    }    
    private function delOneOrder($orderid){
        $times = 0;
        $resp = false;
        while(true){
            $result = $this->apiPositionRes->cancelOrderById(['symbol' => $this->symbol, 'orderId' => $orderid],$times);
            if (array_key_exists("status", $result)) {
                $times = 0;
                while(true){
                    if ($result['status'] === 'CANCELED'){
                        $resp = true;
                        break;
                    }else{
                        sleep(5);
                        $times = $times + 1;
                        if ($times > 5){
                            $rep = false; 
                            break;
                        }                      
                    }
                }
                break;
            }else{
                $times = $times + 1;
                if ($times > 5){
                    $resp = false; 
                    break;
                }                
            }
        }
        return $resp;
    } 
    public function closePosition($maorder = null, $init = true){
        if($maorder === null){
            $dataorder = $this->allOrders();
            $this->maorder['newClientOrderId'] = $dataorder["clientOrderId"] . "D";
            $this->maorder['side'] = $dataorder["side"] === "BUY"?"SELL":"BUY";
            $this->maorder['quantity'] = $dataorder["qty"];
            $this->maorder['symbol'] = $this->symbol;
        }else{
            $this->maorder = $maorder;
            $this->maorder['newClientOrderId'] = $maorder["newClientOrderId"] . "D";
            $this->maorder['side'] = $maorder["side"] === "BUY"?"SELL":"BUY";
            $this->maorder['quantity'] = $maorder["quantity"];
            $this->maorder['reduceOnly'] = 'true';
        }
        $result = $this->delAllOrders(true);
        return $result;
    }

}
