<?php
namespace App;

use App\ValidResponse;
use App\FuTrperm;
use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use GuzzleHttp\Exception\RequestException;
use App\Exceptions\ResponseApiException;
class ApiPositionRes
{
    /**
     * @var Request
     */
    protected $request;

    /**
     * @var array
     */
    protected $keys = [];
        /**
     * @var array
     */
    protected $headers = [];

    /**
     * @var string
     */
    protected $body;
    /**
     * @var FuTrperm  $auth
     */
    protected $auth;

    protected $validresponse;
    protected $websocket;
    const METHOD_GET    = 'GET';
    const METHOD_POST   = 'POST';
    const METHOD_PUT    = 'PUT';
    const METHOD_DELETE = 'DELETE';
    protected $statusCode;
    protected $i = 0;
    protected $client;
    protected $testclient;
    protected $symbol;
    protected $currency = '';
         /**
     * @var OneMaOrder
     */
    protected $oneMaOrder;  
    protected $maorder = [
        'newClientOrderId' => '',
        'side'      => '',
        'quantity'  => '', 
        'workingType' => 'CONTRACT_PRICE',
        'recvWindow' => '5000',
        'symbol'    => '',
        'type'      => 'MARKET', 
        'reduceOnly' => 'true'      
    ];
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];
        $confcl = $params->settings['client'];
        $this->auth = new FuTrperm($config);
        $this->validresponse = new ValidResponse();
        $this->client = $this->getClient($confcl);
        $this->symbol = $config['symbol'];
    }
    /**
     * @param array $config
     * @return Client
     */
    private function buildQuery($params = [])
    {
        $new_arr = array();
        $query_add = '';
        foreach ($params as $label=>$item) {
            if ( gettype($item) == 'array' ) {
                foreach ($item as $arritem) {
                    $query_add = $label . '=' . $arritem . '&' . $query_add;
                }
            } else {
                $new_arr[$label] = $item;
            }
        }
        $query = http_build_query($new_arr, '', '&');
        $query = $query_add . $query;
        return $query;
    } 
    private function getClient(array $config)
    {
        $key = md5(json_encode($config));
        if (isset($clients[$key])) {
            return $clients[$key];
        }
        $clients[$key] = new Client($config);
        return $clients[$key];
    }
    private function getApiData($result)
    {
        $body = $this->validresponse->getBody(true);
        if (!isset($body['data'])) {
            //var_dump($body);
            return null;
        }
        return $body['data'];
    }
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print($date . ": " . $from );
    }
    private function printLogArry($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print($date . " error:" . json_encode($from) .chr(10));
        //var_dump($date . " error:" . json_encode($from));
    }    
    public function getKlines($interval)
    {
        $params = [
            'symbol' => $this->symbol,
            'interval' => $interval,
            'limit' => 100]; //original en 300, 100 para pivot, soporte y resistencia
        $query = '?' . http_build_query($params);
        try {
            $i=0;
            $output = [];
            $result = $this->client->request('GET', 'fapi/v1/klines' ,[
                'headers' =>  $this->auth->getHeaders(),
                'query' => $params
            ]);
            $data = $this->validresponse->getApiData(true, $result);
            $interval =  $params['interval'];
            foreach ($data as $tick) {
                list($openTime, $open, $high, $low, $close, $volact, $closeTime, $baseVolume, $trades, $assetBuyVolume, $takerBuyVolume, $ignored) = $tick;
                $output[$i] = [
                    "open" => $open,
                    "high" => $high,
                    "low" => $low,
                    "close" => $close,
                    "volume" => $baseVolume,
                    "openTime" => $openTime, //(new \DateTime(date('m/d/Y H:i:s',intval($openTime)/1000)))->format('Y-m-d H:i:s'),
                    "closeTime" => $closeTime, //(new \DateTime(date('m/d/Y H:i:s',intval($closeTime)/1000)))->format('Y-m-d H:i:s'),
                    "volact" => $volact,
                    "baseVolume" => $baseVolume,
                    "trades" => $trades,
                    "assetBuyVolume" => $assetBuyVolume,
                    "takerBuyVolume" => $takerBuyVolume,
                    "opetype" => 0,
                    "interval" => $interval,
                    "adx" => 0,
                    "adxa" => 0,            
                    "mdi" => 0,
                    "pdi" => 0
                ];
                $i = $i + 1;
            }      
            return $output;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }               
    }

    /**
     * Place a new order.
     *
     * @param array $order
     * @return array
     */
    public function createOrder($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{

            $url = $this->auth->signature('fapi/v1/order', self::METHOD_POST, $params);
            $result = $this->client->request(self::METHOD_POST, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog('>>>>>:' . $exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
    }
    /**
     * Cancel an order.
     *
     * @param array $orderID
     * @return array
     */    
    public function cancelOrderById($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('fapi/v1/order', self::METHOD_DELETE, $params);
            $result = $this->client->request(self::METHOD_DELETE, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
    }
    public function cancelAllOrders($params, $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            //$url = $this->auth->signature('/fapi/v1/countdownCancelAll', self::METHOD_POST, $params); 
            $url = $this->auth->signature('/fapi/v1/allOpenOrders', self::METHOD_DELETE, $params);
            $result = $this->client->request(self::METHOD_DELETE, $url, [
                'headers' => $this->headers
            ]);
            return $this->validresponse->getApiData(true, $result);
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }   
    }
    public function getListOrder(array $params = [], $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('/fapi/v1/allOrders', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $items = $this->validresponse->getApiData(true, $result);
            /*
            foreach ($items as $item) {
                $id = $item['orderId'];
                $idc = $item["clientOrderId"];
                $side = $item['side'];
                $value = $item['stopPrice'];
                $stop = $item['type'];
                $createdAt = $item['time'];
                $updatedAt = $item['updateTime'];
                $stat =   $item['status'];  
                $orig  = $item['origType'];      
		        if($stop !== ''){
                    $created = (new \DateTime(date('m/d/Y H:i:s',intval($createdAt)/1000)))->format('Y-m-d H:i:s');
                    $update = (new \DateTime(date('m/d/Y H:i:s',intval($updatedAt)/1000)))->format('Y-m-d H:i:s');  
                    $this->printLog(' update: ' . $update .' id:'.$id .  ' cliId:'.$idc . ' side:' . $side . ' type:' . $stop. ' origen:' . $orig. ' status:' . $stat . ' value:' . $value . chr(10));
                }
            }*/
            return $items;
        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
   
    }
    /**
     * List orders.
     *
     * @param array $params -> status
     * @param array $pagination
     * @return array
     */
    public function getStopOrder(array $params = [], $times)
    {
        $query = '?' . http_build_query($params);
        $this->headers = $this->auth->getHeaders();
        try{
            $url = $this->auth->signature('/fapi/v1/openOrders', self::METHOD_GET, $params);
            $result = $this->client->request(self::METHOD_GET, $url, [
                'headers' => $this->headers
            ]);
            $items = $this->validresponse->getApiData(true, $result);
            /*
            foreach ($items as $item) {
                $id = $item['orderId'];
                $side = $item['side'];
                $value = $item['stopPrice'];
                $stop = $item['type'];
                $createdAt = $item['time'];
                $updatedAt = $item['updateTime'];
                $stat =   $item['status'];         
                if($stop !== ''){
                    $created = (new \DateTime(date('m/d/Y H:i:s',intval($createdAt)/1000)))->format('Y-m-d H:i:s');
                    $update = (new \DateTime(date('m/d/Y H:i:s',intval($updatedAt)/1000)))->format('Y-m-d H:i:s');  
                    var_dump('id:'.$id. ' side:' . $side . ' stop:' . $stop. ' status:' . $stat . ' value:' . $value . ' create:' . $created . ' update: ' . $update);
                }

            };
            */
            return ['items' => $items];

        } catch (RequestException $exp) {
            $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
            $this->printLogArry($message);
            return $message;
        } catch (ResponseApiException $exp) {
            $this->printLog($exp->getMessage() .chr(10));
            return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
        }  
   
    }  



}