<?php
include './vendor/autoload.php';
use App\Exceptions\ResponseApiException;
//use GuzzleHttp\Exception\CustomExceptions;
use GuzzleHttp\Exception\RequestException;
use App\ValidResponse;
use App\FuTrperm;
use GuzzleHttp\Client;
use App\SendTelegram;
$settings = require 'settings.php';
$configt = $settings['settings']['config'];
$apiTelegram = new SendTelegram($configt);



const METHOD_PUT = 'PUT';
const METHOD_GET = 'GET';
const METHOD_POST = 'POST';

function getClient(array $config)
{
    $key = md5(json_encode($config));
    if (isset($clients[$key])) {
        return $clients[$key];
    }
    $clients[$key] = new Client($config);
    return $clients[$key];
}
function getPrice($params, $configt)
{
    $config = [
        'base_uri'        => 'https://fapi.binance.com/', 
        'timeout' => 30,
        'connect_timeout' => 30,
        'http_errors'     => true,
        'verify'          => 1,
        'skipVerifyTls' => false
    ];
    $auth = new FuTrperm($configt);
    $headers = $auth->getHeaders();
    $client = getClient($config);
    try{
        $url = $auth->signature('fapi/v1/ticker/price', METHOD_GET, $params);
        $result = $client->request(METHOD_GET, $url, [
            'headers' => $headers
        ]);
        $mustresp = new ValidResponse();
        return $mustresp->getApiData(true, $result);
    } catch (RequestException $exp) {
        $message = json_decode(json_decode($exp->getMessage(),true)['summary'], true);
        return $message;
    } catch (ResponseApiException $exp) {
        print($exp->getMessage() .chr(10));
        //return ['code' => $exp->getCode(), 'msg' => $exp->getMessage()];
    } 
}
var_dump(getPrice(['symbol' => 'dotusdt'], $configt));