<?php

include './vendor/autoload.php';
$settings = require 'settings.php';
$config = $settings['settings']['config'];
use App\ResponseApi;
use App\SetOrdersBuySel;
use App\PivotCalculator;
use App\ATRCalculator;
$apiResponse = new ResponseApi($config);
$apiSetOrdersBuySel = new SetOrdersBuySel($config);
$pivotCalculator = new PivotCalculator(5,5);
$symbol = 'DOTUSDT';
$currency = 'USDT';
$closes = [];
$highs = [];
$lows = [];
$rsiLBR = [];
$priceLL = [];
$priceHH = [];
$rsiHL = [];
$rsiLH = [];
$upCond = [];
$doCond = [];
$vala = [];
$valb = [];
$pd = 14;
$ba = 5;
$FTP = $config['atrtp'];
$FSL = $config['atrsl'];
function array_key_last(array $arr) {
    $i = 0;
    foreach($arr as $key  => $unused) {
        $i = $i +1;
        //return $key;
    }
    return $key;
}
function array_key_first(array $arr) {
    foreach($arr as $key => $unused) {
        return $key;
    }
    return NULL;
}
function valuewhen($valueFound, $valueLBR, $l){
    for ($i = count($valueLBR) -$l; $i > 0; $i--) {
        if($valueFound === $valueLBR[$i]){
            print("i:{$i} valueFound:{$valueFound}" .chr(10));
            return $i;
        }
    }
    return 0;
}
function inRange($plFound, $valueLBR){
    $rangeUpper = 60;
    $rangeLower = 5;
    for ($i = count($valueLBR) -1; $i > 0; $i--) {
        //print("range plFound:{$plFound[$i]} rsiLBR:{$rsiLBR} ran:{$rang}" . chr(10));
        if($plFound === $valueLBR[$i]){
            if($rangeLower < $i and $i <= $rangeUpper){
                //print("i:{$i} plFound:{$plFound}" .chr(10));
                return 1;
            }
        }
    }
    return 0;
}
function getPivotClassic($highs, $lows, $closes, $idx){
    $pivResp = [];
    $ppcal = [];
    $pplh = [];
    $factor = 3;
    $pd = 14;

    for ($x = 1; $x <= $idx; $x++) {
        $pp = round((($highs[$x-1] + $closes[$x-1] + $lows[$x-1]) / 3), 3);
        $range = round(($highs[$x-1] - $lows[$x-1]),3);
        $ppcal = [
            'r1' => round(($pp * 2) - $lows[$x-1],3),
            'r2' => round($pp + $range,3),
            'r3' => round(($pp + ($range * 2)),3),
            'r4' => round(($pp + ($range * 3)),3),
            's1' => round((($pp * 2) - $highs[$x-1]), 3),
            's2' => round($pp - $range,3),
            's3' => round(($pp - ($range * 2)),3),
            's4' => round(($pp - ($range * 3)),3),
        ];
        $pplh[] = $pp;
        $pivResp[] = $ppcal;
    }
    $pivotCalculator = new PivotCalculator(5,5);
    $pivots_low = $pivotCalculator->pivot($pplh,  'low',5,5);
    $pivots_high = $pivotCalculator->pivot($pplh, 'high',5,5);
    $bands = $pivotCalculator->calculate_bands($pivots_high, $pivots_low, $factor, $pd, $highs, $lows, $closes);
    $idl = array_key_last($pivResp);
    $idb = array_key_last($bands[0]);
    $resp = [
        's1' => $pivResp[$idl]['s1'],
        's2' => $pivResp[$idl]['s2'],
        's3' => $pivResp[$idl]['s3'],
        'r1' => $pivResp[$idl]['r1'],
        'r2' => $pivResp[$idl]['r2'],
        'r3' => $pivResp[$idl]['r3'],
        'supo' => $bands[0][array_key_last($bands[0])],
        'resi' => $bands[1][array_key_last($bands[1])],
        'tren' => $bands[2][array_key_last($bands[2])],
        'trai' => $bands[3][array_key_last($bands[3])],            
    ];


    //band[1] = resistance
    //band[0] = support 
    print_r($resp);
    return $resp;
}
$json = $apiResponse->getKlines('15m');
for ($x = 0; $x < count($json); $x++) {
    array_push($closes, $json[$x]["close"]);
    array_push($highs, $json[$x]["high"]);
    array_push($lows, $json[$x]["low"]);
}
$result = $apiResponse->getPrice(['symbol' => "DOTUSDT"], 0);
$price = $result["price"];
$idm = count($json);
$bands = getPivotClassic($highs, $lows, $closes, $idm);
$atr_calculator = new ATRCalculator($pd);
$atr = $atr_calculator->update($highs, $lows, $closes); 
$iatr = array_key_last($atr); 
print('atr-tp:' . ($price + ($FTP * $atr[$iatr])) .chr(10));
print('atr-sl:' . ($price - ($FSL * $atr[$iatr])) .chr(10));
//$tp = ($price + ($FTP * $atr[$iatr]));
//$sl = ($price - ($FSL * $atr[$iatr]));
$allrsi = trader_rsi($closes, $pd);
$allmacd = trader_macd($closes,12,26,9);
for ($i = array_key_last($allrsi); $i >= array_key_first($allrsi); $i--) {
    $rsi[] =$allrsi[$i];
}
for ($i = array_key_first($allmacd); $i <= array_key_last($allmacd); $i++) {
    $macd[] = $allmacd[$i];
}
for ($i = $ba; $i < count($rsi); $i++) {
   $rsiLBR[] = $rsi[$i];
}
//********** LOW **********
// Regular Alcista
// rsi: Higher Low
print("Regular Alcista" .chr(10));
for ($i = array_key_last($lows); $i >= array_key_first($lows); $i--) {
    $low[] = $lows[$i];
}
for ($i = $ba; $i < count($low); $i++) {
    $lowLBR[] = $low[$i];
}
$plFound = $pivotCalculator->pivotRSI($rsi,  'low',5,5);
print_r($plFound);
print(chr(10));
if(count($plFound) >= 2){
    $upCond = 0;
    for ($i = 1 ; $i >=0 ; $i--) {
        if($plFound[$i] > 0){
            $idx = valuewhen($plFound[$i], $rsiLBR,1);
            $vala[] = $idx;
            $rsiHL[] = $rsiLBR[$idx];
            $priceLL[] = $lowLBR[$idx];
        }
    
    }

    $difr = $rsiHL[0] - $rsiHL[1];
    $difp = $priceLL[0] - $priceLL[1];
    switch($difr >= 0){
        case true:
            if($difp >= 0){
                $upCond = 0;
            }else{
                $upCond = 1;
            }
            break;
        default:
            if($difp <= 0){
                $upCond = 0;
            }else{
                $upCond = 1;
            }
    }

}
print("val0 alcista:{$vala[0]}" .chr(10));
print("difr alcista:{$difr}" .chr(10));
print("difp alcista:{$difp}" .chr(10));
print("upCond:{$upCond}" . chr(10));
//********** HIGH **********
// Regular Bajista
// rsi: Lower High
print("Regular Bajista" .chr(10));
$phFound = $pivotCalculator->pivotRSI($rsi,  'high',5,5);
print_r($phFound);
print(chr(10));
if(count($phFound) >= 2){
    $doCond = 0;
    for ($i = 1 ; $i >=0 ; $i--) {
        if($phFound[$i] > 0){
            $idx = valuewhen($phFound[$i], $rsiLBR,1);
            $valb[] = $idx;
            $rsiLH[] = $rsiLBR[$idx];
            $priceHH[] = $lowLBR[$idx];
        }
    
    }
    $difr = $rsiLH[0] - $rsiLH[1];
    $difp = $priceHH[0] - $priceHH[1];
    switch($difr >= 0){
        case true:
            if($difp >= 0){
                $doCond = 0;
            }else{
                $doCond = 1;
            }
            break;
        default:
            if($difp <= 0){
                $doCond = 0;
            }else{
                $doCond = 1;
            }
    }

}
print("val0 bajista:{$valb[0]}" .chr(10));
print("difr bajista:{$difr}" .chr(10));
print("difp bajista:{$difp}" .chr(10));
print("doCond:{$doCond}" . chr(10));
if($vala[1] < $valb[1]){
    print("**** alcista ****" .chr(10));
}else{
    print("**** bajista" .chr(10));
}


/*
$plFound = $pivotCalculator->pivot($rsi,  'low');
for ($i = 0 ; $i < count($plFound); $i++) {
    if($plFound[$i] > 0){
        $vala = valuewhen($plFound[$i], $rsiLBR,1);
        //$ran = inRange($plFound[$i], $rsiLBR);
        for ($x = ($vala - 1); $x >= $to; $x--) {
            if($rsiLBR[$x] > $rsiLBR[$vala] and $ran){
                $rsiHL[] = 1;
            }
        }
        $to = $vala + 1;
    }

}

if(count($rsiHL) > 0){
    $to = 0;
    for ($i = 1 ; $i < count($plFound); $i++) {
        if($plFound[$i] > 0){
            $vala = valuewhen($plFound[$i], $rsiLBR, 1);
            for ($x = ($vala - 1); $x >= $to; $x--) {
                if($lowLBR[$x] < floatval($lowLBR[$vala])){
                    $priceLL[] = 1;
                }
            }
            $to = $vala + 1;
        }
    }
}
if(count($rsiHL) > 0 and count($priceLL)){
    for ($i = 1 ; $i < count($plFound); $i++) {
        if($plFound[$i] > 0 and $rsiHL[$i] and $priceLL[$i]){
            $upCond[] = 1;
        }
    }
}
*/
//********** HIGH **********
// Regular Bajista
// rsi: Lower High
/*
for ($i = array_key_last($highs); $i >= array_key_first($highs); $i--) {
    $high[] = $highs[$i];
}
for ($i = $ba; $i < count($high); $i++) {
    $highLBR[] = $high[$i];
}
$to = 0;
$phFound = $pivotCalculator->pivot($rsi,  'high');
for ($i = 1 ; $i < count($phFound); $i++) {
    if($phFound[$i] > 0){
        $vala = valuewhen($phFound[$i], $rsiLBR,1);
        $ran = inRange($phFound[$i], $rsiLBR);
        for ($x = ($vala - 1); $x >= $to; $x--) {
            if($rsiLBR[$x] < $rsiLBR[$vala] and $ran){
                $rsiLH[] = 1;
            }
        }
        $to = $vala + 1;
    }

}
if(count($rsiLH) > 0){
    $to = 0;
    for ($i = 1 ; $i < count($phFound); $i++) {
        if($phFound[$i] > 0){
            $vala = valuewhen($phFound[$i], $rsiLBR, 1);
            for ($x = ($vala - 1); $x >= $to; $x--) {
                if($highLBR[$x] > floatval($highLBR[$vala])){
                    $priceHH[] = 1;
                }
            }
            $to = $vala + 1;
        }
    }
}
if(count($rsiLH) > 0 and count($priceLL)){
    for ($i = 1 ; $i < count($phFound); $i++) {
        if($phFound[$i] > 0 and $rsiLH[$i] and $priceHH[$i]){
            $doCond[] = 1;
        }
    }
}
*/