<?php
    public function getAlgoritPivot()
    {
        $factor = 3;
        $pd = 14;
        $highs = [];
        $lows = [];
        $closes = [];
        $this->CV = 0;
        $vai = array( 1 => ['interval' => '15m','vre' => []]);
        $adx = 0;        
        for ($i = 1; $i <= 1; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
        }
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
        }
        $allrsi = trader_rsi($closes, $pd);
        $rsi = end($allrsi);
        //$rsi = prev($allrsi); //rsi actual
        $pivotCalculator = new PivotCalculator(5,5);
        $this->rsiCalculator = new RsiCalculator($this->config);
        $pivots_low = $pivotCalculator->pivot($lows,  'low',5,5);
        $pivots_high = $pivotCalculator->pivot($highs, 'high',5,5);
        // calculate Divergence Start
        // calculate Divergence End
        $bands = $pivotCalculator->calculate_bands($pivots_high, $pivots_low, $factor, $pd, $highs, $lows, $closes);
        $idx = count($json)-1;
        $supo = count($bands[0])-1;
        $resi = count($bands[1])-1;
        $trail = count($bands[3])-1;
        $trend = count($bands[2])-1;
        //print( 'en algor. trend:' . ($bands[2][$idx] == 1?"comprar":"vender" ) . " trail:" . $bands[3][$idx] . " support:" .$bands[0][$idx] . " resistance:" . $bands[1][$idx] . chr(10)) ;
        $this->atrCalculator = new ATRCalculator($pd);
        $atr = $this->atrCalculator->update($highs, $lows, $closes);
        // preparar la acción
        $accion = "Mantener"; 
        /*
        if($bands[2][$idx] === 1){
            $may = "";
            $accion = "Comprar"; 
            $emitir = 1;
            $this->CV = 1;          
        }else{
            $may = "";
            $accion = "Vender"; 
            $emitir = 1;   
            $this->CV = 2;           
        }
        */
        if($rsi <= 33){
            $may = "";
            $accion = "Comprar"; 
            $emitir = 1;
            $this->CV = 1;          
        }elseif($rsi >= 67){
            $may = "";
            $accion = "Vender"; 
            $emitir = 1;   
            $this->CV = 2;           
        }else{
            $may = "";
            $accion = "Mantener"; 
            $emitir = 0;   
            $this->CV = 0;              
        }            
        $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($json[$idx]["openTime"])/1000)))->format('Y-m-d H:i:s');
        $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($json[$idx]["closeTime"])/1000)))->format('Y-m-d H:i:s');
        $interarry = "[" . $vai[1]["interval"]  . "]";
        $tokentel = [
            "fechaope" => $fechaope,
            "fechaclo" => $fechaclo,
            "support" => $bands[0][$supo],
            "resistance" => $bands[1][$resi],   
            "potp" => 0,
            "posl" => 0,
            "rsi" => $rsi,
            "close" => $json[$idx]['close'],
            "open" => $json[$idx]['open'],
            "interval" => $interarry,
            "interlow" => $vai[1]["interval"],
            "trail" => $bands[3][$trail],
            "trend" => $bands[2][$trend],
            "accion" => $accion,
            "may" => $may,
            "tim" => $json[$idx]["closeTime"]/1000,
            "init" => 0,
            'timezone' => $this->config['timezone'],
            'locale' => $this->config['locale'],
            'telusers' => $this->config['telusers'],
            'algorit' => $this->config['algorit'],
            "resCV" => []
        ];
        $result = $this->apiResponse->getPrice(['symbol' => "DOTUSDT"], 0);
        $price = $result["price"];
        //if($bands[2][$idx] === 1){
        if($rsi <= 33){
            //Compra/long, restar al soporte = sl, restar  a la resistencia = tp
            //calculos por resistencia y soporte
            //Bearing
            $tp = $bands[1][$idx] - 0.005; //band[1] = resistance
            $sl = $bands[0][$idx] - 0.005; //band[0] = support 
            //calculos por ATR
            //$tp = ($price + ($this->FTP * $atr[$idx]));
            //$sl = ($price - ($this->FSL * $atr[$idx]));
            $potp = round(((100 - ($tp * 100)/$price)*-1),2);
            $posl = round(((100 - ($sl * 100)/$price)*1),2);
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
            }elseif($potp > 0.8){
                $potp = 0.8;
            }
            $posl = $potp * 2;
            $tokentel["potp"] = $potp;
            $tokentel["posl"] = $posl;           
            //if($tp <= $price or $sl >= $price or $lows[$idx] < $sl){
            $this->printLog("Tp/Sl - portp:" . $potp . " porsl:" . $posl . " tp:" . $tp  . " sl:" . $sl . chr(10));

            //if($tp <= $price or $sl >= $price or $potp <= 0 or $posl <= 0){   
            if($tp <= $price or $sl >= $price or $potp <= 0 or $posl <= 0){                             
                $emitir = 0;
                $accion = "Mantener";
                //$tokentel["accion"] = $accion;
            }
            $lom = $highs[$idx] < $sl?" <":" >=";
            $tp = round($price +  (($price * $potp) / 100),3);
            $sl = round($price -  (($price * $posl) / 100),3);  
            $this->printLog("Tp/Sl - price:" . $price . " tp:" . $tp  . " sl:" . $sl . " rsi:" . $rsi . " acción:" . $accion . chr(10));
        }elseif($rsi >= 67){
            // Venta/Short , sumar al soporte = tp, sumar a la resistencia = sl
            //calculos por resistencia y soporte
            $tp = $bands[0][$idx] + 0.005; //band[0] = support 
            $sl = $bands[1][$idx] + 0.005; //band[1] = resistance
            //calculos por ATR
            //$tp = ($price - ($this->FTP * $atr[$idx]));
            //$sl = ($price + ($this->FSL * $atr[$idx]));
            $potp = round(((100 - ($tp * 100)/$price)*1),2);
            $posl = round(((100 - ($sl * 100)/$price)*-1),2);
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
            }elseif($potp > 0.8){
                $potp = 0.8;
            }
            $posl = $potp * 2;
            $tokentel["potp"] = $potp;
            $tokentel["posl"] = $posl; 
            //if($tp >= $price or $sl <= $price or $highs[$idx] > $sl){
            $this->printLog("Tp/Sl - portp:" . $potp . " porsl:" . $posl . chr(10));
            if($tp >= $price or $sl <= $price  or $potp <= 0 or $posl <= 0){
                $emitir = 0;
                $accion = "Mantener";
                //$tokentel["accion"] = $accion;
            }
            $him = $highs[$idx] > $sl?" >":" <=";
            $tp = round($price -  (($price * $potp) / 100),3);
            $sl = round($price +  (($price * $posl) / 100),3);  
            $this->printLog("Tp/Sl - price:" . $price . " tp:" . $tp  . " sl:" . $sl . " rsi:" . $rsi . " acción:" . $accion . chr(10));
        }else{
            $accion = "Mantener"; 
            $emitir = 0;   
            $this->CV = 0;              
        }  
        $this->algResp = [
            "CV" => $this->CV,
            "emitir" => $emitir,
            "tokentel" => $tokentel,
            "rsi" => $rsi
        ];
    }
    public function getAlgoritMdiAdx()
    {
        $vai = array( 1 => ['interval' => '3m','vre' => []], 2 => ['interval' => '15m','vre' => []], 3 => ['interval' => '30m','vre' => []]);
        $adx = 0;        
        for ($i = 1; $i <= 3; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
            /* calculo ema's y adx */ 
            $vai[$i]["vre"] = $this->getMdiAdx($json, $vai[$i]['interval']);
        }
        $emitir = 0;
        $may = "";
        if (
            $vai[1]["vre"]["pdi"] > $vai[1]["vre"]["mdi"] and 
            $vai[2]["vre"]["pdi"] > $vai[2]["vre"]["mdi"] and   
            $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
        {
            $vai[1]["vre"]['oty'] = $vai[3]["vre"]["adx"] >= 20?1:2; //1:compra, 2:venta
        }elseif (
            $vai[1]["vre"]["mdi"] > $vai[1]["vre"]["pdi"] and 
            $vai[2]["vre"]["mdi"] > $vai[2]["vre"]["pdi"] and 
            $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
        {
            $vai[1]["vre"]['oty'] = $vai[3]["vre"]["adx"] >= 20?2:1; //1:compra, 2:venta            
        }else{
            $vai[1]["vre"]['oty'] = 0;
        }  
        if($vai[1]["vre"]["oty"] >= 0){
            $dmi3 = "[pdi:" . $vai[1]["vre"]["pdi"] . ", mdi:" . $vai[1]["vre"]["mdi"] .  "]";
            $dmi15 = "[pdi:" . $vai[2]["vre"]["pdi"] . ", mdi:" . $vai[2]["vre"]["mdi"] .  "]";
            $interarry = "[" . $vai[1]["vre"]["interval"] . "," . $vai[2]["vre"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($vai[1]["vre"]['oty'] === 0){
                $accion = "Mantener"; 
                if($this->CV === 2){
                    $emitir = 0;
                    if (
                        $vai[1]["vre"]["mdi"] > $vai[1]["vre"]["pdi"] and 
                        $vai[2]["vre"]["mdi"] > $vai[2]["vre"]["pdi"] and   
                        $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
                    {
                        $this->CV = 0;
                        $may = "rompe en V"; 
                    }else{
                        $this->CV = 2;
                        $may = "menor";
                    }
                }elseif($this->CV === 1){
                    $emitir = 0;      
                    if (
                        $vai[1]["vre"]["pdi"] > $vai[1]["vre"]["mdi"] and 
                        $vai[2]["vre"]["pdi"] > $vai[2]["vre"]["mdi"] and   
                        $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
                    {
                        $this->CV = 0;
                        $may = "rompe en C"; 
                    }else{
                        $this->CV = 1;
                        $may = "mayor";
                    }                
                }
            }elseif($vai[1]["vre"]['oty'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = ($this->CV === 1)?0 :1 ;
                $this->CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = ($this->CV === 2 )?0:1;   
                $this->CV = 2;           
            }            
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,  
                "dmi3" => $dmi3,
                "dmi15" => $dmi15,  
                "close" => $vai[1]["vre"]['close'],
                "open" => $vai[1]["vre"]['open'],
                "interval" => $interarry ,
                "adx3m" => $vai[1]["vre"]["adx"],
                "adx3ma" => $vai[1]["vre"]["adxa"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $vai[1]["vre"]["closeTime"]/1000,
                "init" => 0,
                'timezone' => $this->config['timezone'],
                'locale' => $this->config['locale'],
                'telusers' => $this->config['telusers'],
                "resCV" => []
            ];
            $tokentelp = $fechaope . "|" . $fechaclo . "|dmi3:" . $dmi3 . "|dmi15:" . $dmi15 . "|adx3m:" . $vai[1]["vre"]["adx"] .
            "|adx3ma:" . $vai[1]["vre"]["adxa"] ."|close:" .  $vai[1]["vre"]['close'] . "|open:" . $vai[1]["vre"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cva:" . $this->CV . chr(10);
             if ($emitir === 1){
                var_dump($tokentelp);
             }
             $this->algResp = [
                "CV" => $this->CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
                
        }  
         
    }
    public function getAlgoritEmaAdx()
    {
        $this->CV = 0;
        $vai = array( 1 => ['interval' => '30m','vre' => []], 2 => ['interval' => '15m','vre' => []]);
        $adx = 0;        
        for ($i = 1; $i <= 2; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
            /* calculo ema's y adx */ 
            $vai[$i]["vre"] = $this->getEmaAdx($json, $this->config['emalo'], $this->config['emahi'], $vai[$i]['interval']);
        }
        $emitir = 0;
        $may = "";
        if (
            $vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"]  and 
            $vai[2]["vre"]["emalo"] > $vai[2]["vre"]["emahi"] and   
            $vai[1]["vre"]["adx"] > 20 and $vai[2]["vre"]["adx"] > 20 and
            $vai[1]["vre"]['close'] > $vai[1]["vre"]['open']){
            $vai[1]["vre"]['oty'] = 1; //compra
        }elseif (
            $vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"]  and 
            $vai[2]["vre"]["emalo"] < $vai[2]["vre"]["emahi"] and 
            $vai[1]["vre"]["adx"] > 20 and $vai[2]["vre"]["adx"] > 20 and
            $vai[1]["vre"]['close'] < $vai[1]["vre"]['open']){
            $vai[1]["vre"]['oty'] = 2;   // venta      
        }else{
            $vai[1]["vre"]['oty'] = 0;
        }   
        if($vai[1]["vre"]["oty"] >= 0){
            $emalow = "[" . $vai[1]["vre"]["emalo"] . "," . $vai[2]["vre"]["emalo"] .  "]";
            $emahigh = "[" . $vai[1]["vre"]["emahi"] . "," . $vai[2]["vre"]["emahi"] .  "]";
            $interarry = "[" . $vai[1]["vre"]["interval"] . "," . $vai[2]["vre"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($vai[1]["vre"]['oty'] === 0){
                $accion = "Mantener"; 
                if($this->CV === 2){
                    //$emitir = ($vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"])?1:0;
                    $emitir = 0;
                    $this->CV = ($vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"])?0:2;
                    $may = ($vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"])?"rompe en V":"menor"; 
                }elseif($this->CV === 1){
                    //$emitir = ($vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"])?1:0;
                    $emitir = 0;                
                    $this->CV = ($vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"])?0:1;   
                    $may = ($vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"])?"rompe en C":"mayor";
                }
            }elseif($vai[1]["vre"]['oty'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = ($this->CV === 1)?0 :1 ;
                $this->CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = ($this->CV === 2 )?0:1;   
                $this->CV = 2;           
            }
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,
                "emalow" => $emalow,
                "emahigh" => $emahigh,            
                "close" => $vai[1]["vre"]['close'],
                "open" => $vai[1]["vre"]['open'],
                "interval" => $interarry ,
                "interlow" => $vai[1]["vre"]["interval"],
                "adx30m" => $vai[1]["vre"]["adx"],
                "adx2h" => $vai[2]["vre"]["adx"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $vai[1]["vre"]["closeTime"]/1000,
                "init" => 0,
                'timezone' => $this->config['timezone'],
                'locale' => $this->config['locale'],
                'telusers' => $this->config['telusers'],
                "resCV" => []
            ];
            $tokentelp = "openTime:". $fechaope . "|closeTime:" . $fechaclo . "|low:" . $emalow . "|high:" . $emahigh . "|adx:" . $vai[1]["vre"]["adx"] .
            "|adx2:" . $vai[2]["vre"]["adx"] ."|close:" .  $vai[1]["vre"]['close'] . "|open:" . $vai[1]["vre"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cva:" . $this->CV . chr(10);
             if ($emitir === 1){
                $this->printLog($tokentelp);
             }
             $this->algResp = [
                "CV" => $this->CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
        }  
         
    }
    public function getAlgoritEmaEma()
    {
        $this->CV = 0;
        $vai = array( 1 => ['interval' => '15m','vre' => []]);
        $adx = 0;        
        for ($i = 1; $i <= 1; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
            /* calculo ema's y adx */ 
            $vai[$i]["vre"] = $this->getEmaEma($json, $this->config['emaon'], $this->config['emaon'], $vai[$i]['interval']);
        }
        $difema = round(abs($vai[1]["vre"]["emaac"] - $vai[1]["vre"]["emaan"]), 3);
        $emitir = 0;
        $may = "";
        if ($vai[1]["vre"]["emaac"] > $vai[1]["vre"]["emaan"] and $difema >= 0.004){
            $vai[1]["vre"]['oty'] = 1; //compra
        }elseif ($vai[1]["vre"]["emaac"] < $vai[1]["vre"]["emaan"] and $difema >= 0.004){
            $vai[1]["vre"]['oty'] = 2;   // venta      
        }else{
            $vai[1]["vre"]['oty'] = 0;
        }  
        print( 'en algor. ema-act:' . $vai[1]["vre"]["emaac"] . ' ena-ant:' . $vai[1]["vre"]["emaan"] . ' dif:' . $difema . ' oty:' . $vai[1]["vre"]['oty'] . chr(10)) ;
        if($vai[1]["vre"]["oty"] >= 0){
            $emaacw = "[" . $vai[1]["vre"]["emaac"] . "," . $vai[1]["vre"]["emaan"] .  "]";
            $interarry = "[" . $vai[1]["vre"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($vai[1]["vre"]['oty'] === 0){
                $accion = "Mantener"; 
            }elseif($vai[1]["vre"]['oty'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = 1;
                $this->CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = 1;   
                $this->CV = 2;           
            }
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,
                "emaacw" => $emaacw,
                "emaangh" => [],            
                "close" => $vai[1]["vre"]['close'],
                "open" => $vai[1]["vre"]['open'],
                "interval" => $interarry ,
                "interlow" => $vai[1]["vre"]["interval"],
                "adx30m" => $vai[1]["vre"]["adx"],
                //"adx2h" => $vai[2]["vre"]["adx"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $vai[1]["vre"]["closeTime"]/1000,
                "init" => 0,
                'timezone' => $this->config['timezone'],
                'locale' => $this->config['locale'],
                'telusers' => $this->config['telusers'],
                "resCV" => []
            ];
            $tokentelp = "openTime:". $fechaope . "|closeTime:" . $fechaclo . "|act:" . $emaacw . "|ant:" . '[]' . "|adx:" . $vai[1]["vre"]["adx"] .
            "|close:" .  $vai[1]["vre"]['close'] . "|open:" . $vai[1]["vre"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cva:" . $this->CV . chr(10);
             if ($emitir === 1){
                $this->printLog($tokentelp);
             }
             $this->algResp = [
                "CV" => $this->CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
        }  
    }
         
    public function getAlgoritEmaRsi($istp)
    {
        //$this->CV = 0;
        $this->ISTP = $istp;
        $vai = array( 0 => ['interval' => '15m','vre' => []], 1 => ['interval' => '1h','vre' => []]);
        $adx = 0;        
        for ($i = 0; $i <= 1; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
            /* calculo ema's y adx */ 
            $vai[$i]["vre"] = $this->getEmaRsi($json, $this->config['emaon'], $this->config['emaon'], $vai[$i]['interval']);
        }
        $difema = round(abs($vai[0]["vre"]["emaac"] - $vai[0]["vre"]["emaan"]), 3);
        $emitir = 0;
        $may = "";
        if ($vai[0]["vre"]["emaac"] > $vai[0]["vre"]["emaan"] and $difema >= 0.004 and $vai[1]["vre"]["rsi"] >= 50){
            $vai[0]["vre"]['oty'] = 1; //compra
        }elseif ($vai[0]["vre"]["emaac"] < $vai[0]["vre"]["emaan"] and $difema >= 0.004  and $vai[1]["vre"]["rsi"] < 50){
            $vai[0]["vre"]['oty'] = 2;   // venta      
        }else{
            $vai[0]["vre"]['oty'] = 0;
        } 
        print("en algor. RSI[0] init:{$this->RSI} rsi_act:{$vai[0]["vre"]["rsi"]} ISTP:{$this->ISTP}" . chr(10));
        if($this->RSI === 1 and $vai[0]["vre"]["rsi"] < 50){
            $this->ISTP = 0;
        }elseif($this->RSI === 2 and $vai[0]["vre"]["rsi"] >= 50){
            $this->ISTP = 0;
        } 
        if($vai[0]["vre"]["rsi"] >= 50){
            $this->RSI = 1;
        }else{
            $this->RSI = 2;
        }
        print("en algor.RSI end:{$this->RSI} ISTP:{$this->ISTP}" . chr(10));
        print( 'en algor. ema-act:' . $vai[0]["vre"]["emaac"] . ' ena-ant:' . $vai[0]["vre"]["emaan"] . ' dif:' . $difema);
        print(' oty:' . $vai[0]["vre"]['oty'] . ' rsi[0]:' . $vai[0]["vre"]["rsi"] . ' rsi[1]:' . $vai[1]["vre"]["rsi"] . chr(10)) ;
        if($vai[0]["vre"]["oty"] >= 0){
            $emaacw = "[" . $vai[0]["vre"]["emaac"] . "," . $vai[0]["vre"]["emaan"] .  "]";
            $interarry = "[" . $vai[0]["vre"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($vai[0]["vre"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($vai[0]["vre"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;   

            if($vai[0]["vre"]['oty'] === 0){
                $accion = "Mantener"; 
                $this->CV = 0; 
            }elseif($vai[0]["vre"]['oty'] === 1){
                $may = "";
                $accion = "Comprar"; 
                if($this->ISTP === 0){
                    $emitir = 1;
                }else{
                    $emitir = 0;
                }
                $this->CV = 1;     
            }else{
                $may = "";
                $accion = "Vender"; 
                if($this->ISTP === 0){
                    $emitir = 1;
                }else{
                    $emitir = 0;
                } 
                $this->CV = 2;        
            }
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,
                "emaacw" => $emaacw,
                "emaangh" => [],            
                "close" => $vai[0]["vre"]['close'],
                "open" => $vai[0]["vre"]['open'],
                "interval" => $interarry ,
                "interlow" => $vai[0]["vre"]["interval"],
                "adx30m" => $vai[0]["vre"]["adx"],
                //"adx2h" => $vai[2]["vre"]["adx"],
                "difema" => $difema > 0.004?0.8:0.6,
                "accion" => $accion,
                "may" => $may,
                "tim" => $vai[0]["vre"]["closeTime"]/1000,
                "init" => 0,
                "rsi" => 0,
                'timezone' => $this->config['timezone'],
                'locale' => $this->config['locale'],
                'telusers' => $this->config['telusers'],
                "resCV" => []
            ];
            $tokentelp = "openTime:". $fechaope . "|closeTime:" . $fechaclo . "|act:" . $emaacw . "|ant:" . '[]' . "|adx:" . $vai[0]["vre"]["adx"] .
            "|close:" .  $vai[0]["vre"]['close'] . "|open:" . $vai[0]["vre"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cva:" . $this->CV . chr(10);
             if ($emitir === 1){
                $this->printLog($tokentelp);
             }
             $this->algResp = [
                "CV" => $this->CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel,
                "RSI" => $this->RSI,
                "ISTP" => $this->ISTP
             ];
        }  
         
    }
    private function getMdiAdx($json, $interval = '15m')
    {
        $i=0;
        //$json = [];
        $time_period = 14;        
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);      
        $retval = [  
            "adx" => 0,   
            "adxa" => 0,             
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "oty" => 0, 
            "interval" =>  $interval           
        ];
    
    
        $i = count($json) - 2;
        $retval["adx"] = (!empty($adx[$i]))?$adx[$i]:0; 
        $retval["adxa"] = (!empty($adx[$i]))?$adx[$i-1]:0;           
        $retval["mdi"] = (!empty($mdi[$i]))?$mdi[$i]:0; 
        $retval["pdi"] = (!empty($pdi[$i]))?$pdi[$i]:0;
        return $retval;
    }   
    private function getEmaAdx($json, $emalo = 5, $emahi = 60, $interval = '30m')
    {
        $i=0;
        //$json = [];
        $time_period = 14;        
        $ema_name = "ema_" . $emalo ;
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);   
        $ema_vallo =  trader_ema($closes, $emalo); 
        $ema_valhi =  trader_ema($closes, $emahi);
    
        $retval = [
            "emalo" => 0,
            "emahi" => 0,    
            "adx" => 0,    
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volmed" => 0,
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "oty" => 0, 
            "interval" =>  $interval           
        ];
        $i = count($json) - 2;
        $retval["emalo"] = (!empty($ema_vallo[$i]))?$ema_vallo[$i]:0;
        $retval["emahi"] = (!empty($ema_valhi[$i]))?$ema_valhi[$i]:0;  
        $retval["adx"] = (!empty($adx[$i]))?$adx[$i]:0;   
        $retval["mdi"] = (!empty($mdi[$i]))?$mdi[$i]:0; 
        $retval["pdi"] = (!empty($pdi[$i]))?$pdi[$i]:0;
        $retval["volmed"] = $vol_med / (($i > 0)?$i:1);
        return $retval;
    }    
    private function getEmaEma($json, $emaac = 20, $emaan = 20, $interval = '15m')
    {
        ini_set( 'trader.real_precision', '3' );
        $i=0;
        $time_period = 14;        
        $ema_name = "ema_" . $emaac ;
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);   
        $ema_vallo =  trader_ema($closes, $emaac); 
        $ema_valhi =  trader_ema($closes, $emaan);
        $retval = [
            "emaac" => 0,
            "emaan" => 0,    
            "adx" => 0,    
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volmed" => 0,
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "oty" => 0, 
            "interval" =>  $interval           
        ];
        $i = count($json) - 2;
        $retval["emaac"] = (!empty($ema_vallo[$i]))?$ema_vallo[$i]:0;
        $i = count($json) - 3;
        $retval["emaan"] = (!empty($ema_valhi[$i]))?$ema_valhi[$i]:0; 

        return $retval;
    } 
    private function getEmaRsi($json, $emaac = 20, $emaan = 20, $interval = '15m')
    {
        ini_set( 'trader.real_precision', '3' );
        $i=0;
        $time_period = 14;        
        $ema_name = "ema_" . $emaac ;
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14); 
        $ema_vallo =  trader_ema($closes, $emaac); 
        $ema_valhi =  trader_ema($closes, $emaan);
        $rsi = trader_rsi($closes, 14);
        $rsiema = trader_ema($rsi, 14);
        $retval = [
            "emaac" => 0,
            "emaan" => 0,    
            "adx" => 0,    
            "mdi" => 0, 
            "pdi" => 0,   
            "rsi" => 0,      
            "rsiema" => 0,                                                   
            "volmed" => 0,
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "oty" => 0, 
            "interval" =>  $interval           
        ];
        $i = count($json) - 2;
        $x = count($rsiema) + 11;
        $retval["emaac"] = (!empty($ema_vallo[$i]))?$ema_vallo[$i]:0;
        $retval["rsi"] = (!empty($rsi[$i]))?$rsi[$i]:0;
        $retval["rsiema"] = (!empty($rsiema[$x]))?$rsiema[$x]:0;
        $i = count($json) - 3;
        $retval["emaan"] = (!empty($ema_valhi[$i]))?$ema_valhi[$i]:0; 
        return $retval;
    }     