<?php
namespace App;
use App\Exceptions\ResponseApiException;
class ValidResponse
{
    const SUCCESS = 200;
    /**
     * @var Request
     */
    protected $request;

    /**
     * @var array
     */
    protected $headers = [];

    /**
     * @var string
     */
    protected $body;

    /**
     * @var int
     */
    
    protected $statusCode;
    /**
     * @var string
     */
    protected $method;
    /**
     * @var string
     */
    protected $url;

    public function setResponse($result)
    {
        $this->body = $result->getBody();
        $this->statusCode = $result->getStatusCode();
    }

    public function setRequest()
    {
        
    }

    public function getRequest()
    {
        return $this->request;
    }

    public function getHeaders()
    {
        return $this->headers;
    }

    public function getBody($decodeJson = false)
    {
        return $decodeJson ? json_decode($this->body, true) : $this->body;
    }

    public function getStatusCode()
    {
        return $this->statusCode;
    }
    public function getApiCode()
    {
        $body = $this->getBody(true);
        return isset($body['code']) ? $body['code'] : '';
    }

    public function getApiMessage()
    {
        $body = $this->getBody(true);
        return isset($body['msg']) ? $body['msg'] : '';
    }


    public function isSuccessful()
    {
       if ($this->statusCode === self::SUCCESS) {
            return true;
        }
        return false;
    }
    public function mustSuccessful()
    {
        $msg = sprintf(
            '[API]Failure: api code is NOT %s, %s %s, respond code=%s message="%s"',
            //ApiCode::SUCCESS,
            //$this->httpResponse->getRequest()->getMethod(),
            //$this->httpResponse->getRequest()->getRequestUri(),
            //$this->httpResponse->getRequest()->getBodyParams(),
            $this->statusCode,
            $this->method,
            $this->url,
            $this->getApiCode(),
            $this->getApiMessage()
        );
        $exception = new ResponseApiException($msg, 0);
        throw $exception;
    }
    public function __toString()
    {
        $str = 'respond ' . $this->getStatusCode();
        $str .= ' with headers=' . json_encode($this->getHeaders(), JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        $str .= ' with body=' . $this->getBody(false);
        return $str;
    }

    /**
     * @return mixed
     * @throws ResponseApiException
     * @throws HttpException
     */
    public function getApiData($decodeJson, $response)
    {
        $this->setResponse($response);
        if (!$this->isSuccessful()) {
            $this->mustSuccessful();
        }
	    $body = $this->getBody($decodeJson);
        return $body;
        /*
        if (!isset($body['data'])) {
            $this->mustSuccessful();
            return [];
        }
        return $body['data'];
        */
    }
}