<?php
namespace App;


class TelegramTemplate
{
    /**
     * @var array
     */
    protected static $params;
    /**
     * @var string
     */
    protected $alert = '
<b>
*******  "Alerta ********
{locale} 
*** intervalo: 15m ***
</b>{accion}

';
    /**
     * @var string
     */
    protected $openorder = '
<b>**** Apertura de ordenes {algorit} ****</b>
UTC - Apertura: {fechaope}
{locale} 
<b>*** intervalo: {interval} ***</b>
<b>**** {accion} ****</b>
{porAv} % disponible: {avBal} 
precio Entrada: {price} 
TP precio: {impTp} 
SL precio: {impSm}
RSI:{rsi}
cantidad: {qty} 
total ordenado: {ordenado} 
Apalancamiento: {porLe} 
';
    /**
     * @var string
     */
    protected $closeorder = '
<b>**** Cierre de ordenes {algorit} ****</b>
{locale}
<b>******* {cierre} ordenada ********</b> 
{headpro}
TP: % {porTp} precio: {impTp}
SL: % {porSm} precio: {impSm}
{porAv} % disponibleal final: {enBal} 
';
        /**
     * @var string
     */
    protected $cancelorder = '
<b>**** Cierre de ordenes {algorit} ****</b>
{locale}
{cancel}
'; 

    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        static::$params = $params->settings['config'];
    }

    
    private function getContent($replace = [], $template)
    {
        $content = strtr($template, $replace);
        return $content;
    }


    private function setOpenOrder($valret)
    {
        $resCV = $valret['resCV'];
        $orgDate = intval($valret['tim']);        
        $date = new \DateTime(date('m/d/Y H:i:s',$orgDate));
        $date->setTimeZone(new \DateTimeZone(static::$params['timezone']));
        $content_replace = array(
            '{accion}'   => $valret["accion"] ,
            '{fechaope}' => $valret["fechaope"],
            '{algorit}' => $valret["algorit"],
            '{locale}' => static::$params['locale'] . $date->format('Y-m-d H:i:s'),
            '{interval}' => $valret['interval'],
            '{porAv}' => $resCV['porAv'] * 100,
            '{avBal}' => $resCV["avBal"],
            '{price}'=> $resCV["price"],
            '{qty}' => $resCV["qty"],
            '{rsi}'   => $valret["rsi"] ,
            '{ordenado}' => ($resCV["price"] * $resCV["qty"]),
            '{porLe}' => $resCV["porLe"],
            '{impTp}' => $resCV["impTp"],
            '{impSm}' => $resCV["impSm"],
        );
        $content = $this->getContent($content_replace, $this->openorder);
        return $content;
    }
    private function setCloseOrder($valret)
    {
        $resCV = $valret['resCV'];
        $date = new \DateTime('now');
        $date->setTimeZone(new \DateTimeZone(static::$params['timezone']));
        if($resCV['doit'] === 1){
            if ($resCV["Tp"]){
                $headpro = "****** Tp Beneficio ******";
            }else{
                //if ($resCV["camSm"]){
                    //$headpro = "****** Sl Protegido ******";
                //}else{
                    $headpro = " ****** Sl Pérdida ******";                
                //}
            }
            $content_replace = array(
                '{locale}' => static::$params['locale'] . '- Cierre : ' . $date->format('Y-m-d H:i:s'),
                '{cierre}' => $resCV["cierre"],
                '{algorit}' => $valret["algorit"],
                '{headpro}' => $headpro,
                '{porTp}' => $resCV["porTp"],
                '{impTp}' => $resCV["impTp"],
                '{porSm}' => $resCV["porSm"],
                '{impSm}' => $resCV["impSm"],
                '{porAv}' => $resCV['porAv'] * 100,
                '{enBal}' => $resCV["enBal"],
                //'{tpSta}' => $resCV["tpSta"],
                //'{slSta}' => $resCV["slSta"],
            ); 
            $content = $this->getContent($content_replace, $this->closeorder);           
        }else{
            $content_replace = array(
                '{locale}' => static::$params['locale'] . '- Cierre : ' . $date->format('Y-m-d H:i:s'),
                '{cancel}' => "<b>****" . $valret["accion"] . " cancelada" .  " ****</b>"
            ); 
            $content = $this->getContent($content_replace, $this->cancelorder);  
        }
        return $content;
    }

    public function getTemplateAlert($valret)
    {
        $date = new \DateTime('now');
        $date->setTimeZone(new \DateTimeZone(static::$params['timezone']));
        $content_replace = array(
            //'{algorit}' => $valret["algorit"],
            '{locale}' => 'Fecha Hora: ' .static::$params['locale'] .  $date->format('Y-m-d H:i:s'),
            '{accion}' => $valret
        );
        $content = $this->getContent($content_replace, $this->alert);
        return $content;
    }

    public function getTemplateOrder($valret)
    {
        if($valret["init"] === 0){
            $template = $this->setOpenOrder($valret);
        }else{
            $template = $this->setCloseOrder($valret);    
        };
        return $template;
    }
}

