<?php
namespace App;
use App\ATRCalculator;
class PivotCalculator{

    private $lbl = 1;
    private $lbr = 1;
    public function __construct($LBL, $LBR) {
        $this->lbl = $LBL;
        $this->lbr = $LBR;
    }
    private function array_key_last(array $arr) {
        $i = 0;
        foreach($arr as $key  => $unused) {
            $i = $i +1;
            //return $key;
        }
        return $key;
    }
    private function array_key_first(array $arr) {
        foreach($arr as $key => $unused) {
            return $key;
        }
        return NULL;
    }
    private function checkhl($data_back, $data_forward, $hl) {
        if ($hl == 'high' || $hl == 'High') {
            $ref = $data_back[count($data_back)-1];
            for ($i = 0; $i < count($data_back)-1; $i++) {
                if ($ref < $data_back[$i]) {
                    return 0;
                }
            }
            for ($i = 0; $i < count($data_forward); $i++) {
                if ($ref <= $data_forward[$i]) {
                    return 0;
                }
            }
            return 1;
        }
        if ($hl == 'low' || $hl == 'Low') {
            $ref = $data_back[count($data_back)-1];
            for ($i = 0; $i < count($data_back)-1; $i++) {
                if ($ref > $data_back[$i]) {
                    return 0;
                }
            }
            for ($i = 0; $i < count($data_forward); $i++) {
                if ($ref >= $data_forward[$i]) {
                    return 0;
                }
            }
            return 1;
        }
    }
    public function calculate_bands($ph, $pl, $factor, $pd, $highs, $lows, $closes) {
        $center = null;
        $init = 1;
        $re = null;
        $su = null;
        $all_pp = $ph !== null ? $ph : $pl !== null ? $pl : null;
        if ($all_pp !== null) {
            for ($i = 0; $i < count($ph); $i++) {
                if($ph[$i] > 0){
                    $last_pp = $ph[$i];
                }elseif($pl[$i] > 0){
                    $last_pp = $pl[$i];
                }else{
                    $last_pp = 0; 
                }
                // calc center
                    // Weighted calculation
                    if($last_pp > 0){
                        if($init === 1){
                            $init = 0;
                            $center[$i] = $last_pp;
    
                        }else{
                            $center[$i] = ($center[$i-1] * 2 + $last_pp) / 3;
                        }
                    }else{
                        $center[$i] = $center[$i-1];
                    }
    
    
                if($i > 0){
                    $su[$i] = $pl[$i] !== 0 ? $pl[$i] : $su[$i-1]; 
                    $re[$i] = $ph[$i] !== 0 ? $ph[$i] : $re[$i-1];
                    if($su[$i] == 0){
                        $su[$i] = $su[$i-1];
                    }
                    if($re[$i] == 0){
                        $re[$i] = $re[$i-1];
                    }             
                }else{
                    $su[0] = 0;
                    $re[0] = 0;
                }            
            }
            $atr_calculator = new ATRCalculator($pd);
            $atr = $atr_calculator->update($highs, $lows, $closes);
            $TUp = null;
            $TDown = null;
            $Trend = null;
            for ($i = 0; $i <= $this->array_key_last($atr); $i++) {
                if($i < $pd){
                    $atr[$i] = $atr[$pd];
                }
                $Up = $center[$i] - ($factor * $atr[$i]);
                $Dn = $center[$i] + ($factor * $atr[$i]);
                $Up = floatval(intval($Up * 1000))/1000;
                $Dn = floatval(intval($Dn * 1000))/1000;
                $centr = round($center[$i],3);
                $center[$i] = $centr;
                if($i > 0){
    
                    $TUp[$i] = $closes[$i-1] > $TUp[$i-1] ? max($Up, $TUp[$i-1]) : $Up;
                    $TDown[$i] = $closes[$i-1] < $TDown[$i-1] ? min($Dn, $TDown[$i-1]) : $Dn;
                    if($closes[$i] >= $TDown[$i-1]){
                        $Trend[$i] = 1;
                    }elseif($closes[$i] <= $TUp[$i-1]){
                        $Trend[$i] = -1;
                    }else{
                        $Trend[$i] = $Trend[$i-1];
    
                    }
                    //$Trend[$i] = $closes[$i] > $TDown[$i-1] ? 1 : $closes[$i] < $TUp[$i-1] ? -1 : isset($Trend[$i-1]) ? $Trend[$i-1] : 1;
                    $Trailingsl[$i] = $Trend[$i] == 1 ? $TUp[$i] : $TDown[$i];
                    //print("center:" . $center[$i] . " TUp: " . $TUp[$i] . " TDown: " . $TDown[$i] . " close:" . $closes[$i] . " Trailingsl: " 
                    //. $Trailingsl[$i]. " Trend:" . $Trend[$i] . ($Trend[$i] == 1?" Comprar":" Vender") . PHP_EOL);
                }else{
                    $TUp[0] = $Up;
                    $TDown[0] = $Dn;
                    if($closes[$i] >= $TDown[$i]){
                        $Trend[$i] = 1;
                    }elseif($closes[$i] <= $TUp[$i]){
                        $Trend[$i] = -1;
                    }
                    $Trailingsl[$i] = $Trend[$i] == 1 ? $TUp[$i] : $TDown[$i];
                }
    
            }
            return[$su,$re,$Trend,$Trailingsl,$closes];
        }
        return [null, null];
    }
    public function pivotRSI($osc, $highlow, $lbl = 5, $lbr = 5) {
        $left = array();
        $right = array();
        $pivots = array();
        for ($i = 0; $i < count($osc); $i++) {
            //$pivots[$i] = 0.000;
            if ($highlow == 'high' || $highlow == 'High'){
                if ($i < $lbl + 1) {
                    $left[] = $osc[$i];
                }
                if ($i > $lbl) {
                    $right[] = $osc[$i];
                }
                if ($i > $lbl + $lbr) {
                    $left[] = $right[0];
                    array_shift($left);
                    array_shift($right);
                    if ($this->checkhl($left, $right, $highlow)) {
                        $pivots[] = $osc[$i - $lbr];
                    }
                }
            }else{
                if ($i < $lbl + 1) {
                    $left[] = $osc[$i];
                }
                if ($i > $lbl) {
                    $right[] = $osc[$i];
                }
                if ($i > $lbl + $lbr) {
                    $ref = $right[0];
                    $left[] = $right[0];
                    array_shift($left);
                    array_shift($right);
                    if ($this->checkhl($left, $right, $highlow)) {
                        $pivots[] = $osc[$i - $lbr];
                    }
                }
            }
    
        }
        return $pivots;        
    }
    public function pivot($osc, $highlow, $lbl = 5, $lbr = 5) {
        $left = array();
        $right = array();
        $pivots = array();
        for ($i = 0; $i < count($osc); $i++) {
            $pivots[$i] = 0.000;
           if ($highlow == 'high' || $highlow == 'High'){
                if ($i < $lbl + 1) {
                    $left[] = $osc[$i];
                }
                if ($i > $lbl) {
                    $right[] = $osc[$i];
                }
                if ($i > $lbl + $lbr) {
                    $left[] = $right[0];
                    array_shift($left);
                    array_shift($right);
                    if ($this->checkhl($left, $right, $highlow)) {
                        $pivots[$i - $lbr] = $osc[$i - $lbr];
                    }
                }
            }else{
                if ($i < $lbl + 1) {
                    $left[] = $osc[$i];
                }
                if ($i > $lbl) {
                    $right[] = $osc[$i];
                }
                if ($i > $lbl + $lbr) {
                    $left[] = $right[0];
                    array_shift($left);
                    array_shift($right);
                    if ($this->checkhl($left, $right, $highlow)) {
                        $pivots[$i - $lbr] = $osc[$i - $lbr];
                    }
                }
            }
    
        }
        return $pivots;        
    }
    public function pivotClassic($osc, $highlow) {
        $mxmicl = [];
        $maxpp = max($osc["pp"]); 
        $minpp = min($osc["pp"]); 
        for ($x = 0; $x <= count($osc["pp"]); $x++) {
            if($osc["pp"][$x] === $maxpp){
                print("maxpp:{$maxpp} in {$x}" .chr(10));
                break;
            }
        }
        $desde = $x + 1;
        $hasta = count($osc['pp']) - 1;
        $retval = [  
            "clo" => $osc["closes"][$x],   
            "max" => $maxpp,             
            "min" => $minpp,          
        ];
        array_push($mxmicl,$retval);
        while($desde <= $hasta)
        {
            $varmax = [];
            for ($x = $desde; $x <= $hasta; $x++) {
                array_push($varmax, $osc["pp"][$x]);
            }
            if(count($varmax) > 0){
                $maxvv = max($varmax); 
                $minvv = min($varmax);
                for ($x = $desde; $x < $hasta; $x++) {
                    if($osc["pp"][$x] === $maxvv){
                        break;
                    }
                }
                $retval = [  
                    "clo" => $osc["closes"][$x],   
                    "max" => $maxvv,             
                    "min" => $minvv,          
                ];
                array_push($mxmicl,$retval);
                $desde = $x + 1;
                if( $desde > $hasta){
                    break;
                }
            }else{
                break;
            }
    
        } 
        return $mxmicl;        
    }
}