<?php
namespace App;
use App\ResponseApi;
class AlgoritApi
{
    protected $algResp = [
        "CV" => 0,
        "emitir" => 0,
        "tokentel" => []
    ];
    protected $CV;
    /**
     * @var ResponseApi
     */
    protected $apiResponse; 
    protected $config;    
    public function __construct(array $config = [])
    {
        $this->config = $config;
        $this->CV = $config['cv'];
        $this->apiResponse = new ResponseApi($config);
    }
    public function getAlgoritMdiAdx()
    {
        $vai = array( 1 => ['interval' => '3m','vre' => []], 2 => ['interval' => '15m','vre' => []], 3 => ['interval' => '30m','vre' => []]);
        $adx = 0;        
        for ($i = 1; $i <= 3; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
            /* calculo ema's y adx */ 
            $vai[$i]["vre"] = $this->getMdiAdx($json, $vai[$i]['interval']);
        }
        $emitir = 0;
        $may = "";
        if (
            $vai[1]["vre"]["pdi"] > $vai[1]["vre"]["mdi"] and 
            $vai[2]["vre"]["pdi"] > $vai[2]["vre"]["mdi"] and   
            $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
        {
            $vai[1]["vre"]['oty'] = $vai[3]["vre"]["adx"] >= 20?1:2; //1:compra, 2:venta
        }elseif (
            $vai[1]["vre"]["mdi"] > $vai[1]["vre"]["pdi"] and 
            $vai[2]["vre"]["mdi"] > $vai[2]["vre"]["pdi"] and 
            $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
        {
            $vai[1]["vre"]['oty'] = $vai[3]["vre"]["adx"] >= 20?2:1; //1:compra, 2:venta            
        }else{
            $vai[1]["vre"]['oty'] = 0;
        }  
        if($vai[1]["vre"]["oty"] >= 0){
            $dmi3 = "[pdi:" . $vai[1]["vre"]["pdi"] . ", mdi:" . $vai[1]["vre"]["mdi"] .  "]";
            $dmi15 = "[pdi:" . $vai[2]["vre"]["pdi"] . ", mdi:" . $vai[2]["vre"]["mdi"] .  "]";
            $interarry = "[" . $vai[1]["vre"]["interval"] . "," . $vai[2]["vre"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($vai[1]["vre"]['oty'] === 0){
                $accion = "Mantener"; 
                if($this->CV === 2){
                    $emitir = 0;
                    if (
                        $vai[1]["vre"]["mdi"] > $vai[1]["vre"]["pdi"] and 
                        $vai[2]["vre"]["mdi"] > $vai[2]["vre"]["pdi"] and   
                        $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
                    {
                        $this->CV = 0;
                        $may = "rompe en V"; 
                    }else{
                        $this->CV = 2;
                        $may = "menor";
                    }
                }elseif($this->CV === 1){
                    $emitir = 0;      
                    if (
                        $vai[1]["vre"]["pdi"] > $vai[1]["vre"]["mdi"] and 
                        $vai[2]["vre"]["pdi"] > $vai[2]["vre"]["mdi"] and   
                        $vai[1]["vre"]["adx"] > $vai[1]["vre"]["adxa"])
                    {
                        $this->CV = 0;
                        $may = "rompe en C"; 
                    }else{
                        $this->CV = 1;
                        $may = "mayor";
                    }                
                }
            }elseif($vai[1]["vre"]['oty'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = ($this->CV === 1)?0 :1 ;
                $this->CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = ($this->CV === 2 )?0:1;   
                $this->CV = 2;           
            }            
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,  
                "dmi3" => $dmi3,
                "dmi15" => $dmi15,  
                "close" => $vai[1]["vre"]['close'],
                "open" => $vai[1]["vre"]['open'],
                "interval" => $interarry ,
                "adx3m" => $vai[1]["vre"]["adx"],
                "adx3ma" => $vai[1]["vre"]["adxa"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $vai[1]["vre"]["closeTime"]/1000,
                "init" => 0,
                'timezone' => $this->config['timezone'],
                'locale' => $this->config['locale'],
                'telusers' => $this->config['telusers'],
                "resCV" => []
            ];
            $tokentelp = $fechaope . "|" . $fechaclo . "|dmi3:" . $dmi3 . "|dmi15:" . $dmi15 . "|adx3m:" . $vai[1]["vre"]["adx"] .
            "|adx3ma:" . $vai[1]["vre"]["adxa"] ."|close:" .  $vai[1]["vre"]['close'] . "|open:" . $vai[1]["vre"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cva:" . $this->CV . chr(10);
             if ($emitir === 1){
                var_dump($tokentelp);
             }
             $this->algResp = [
                "CV" => $this->CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
                
        }  
         
    }
    public function getAlgoritEmaAdx()
    {
        $this->CV = 0;
        $vai = array( 1 => ['interval' => '30m','vre' => []], 2 => ['interval' => '2h','vre' => []]);
        $adx = 0;        
        for ($i = 1; $i <= 2; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
            /* calculo ema's y adx */ 
            $vai[$i]["vre"] = $this->getEmaAdx($json, $this->config['emalo'], $this->config['emahi'], $vai[$i]['interval']);
        }
        $emitir = 0;
        $may = "";
        if (
            $vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"]  and 
            $vai[2]["vre"]["emalo"] > $vai[2]["vre"]["emahi"] and   
            $vai[1]["vre"]["adx"] > 20 and $vai[2]["vre"]["adx"] > 20 and
            $vai[1]["vre"]['close'] > $vai[1]["vre"]['open']){
            $vai[1]["vre"]['oty'] = 1; //compra
        }elseif (
            $vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"]  and 
            $vai[2]["vre"]["emalo"] < $vai[2]["vre"]["emahi"] and 
            $vai[1]["vre"]["adx"] > 20 and $vai[2]["vre"]["adx"] > 20 and
            $vai[1]["vre"]['close'] < $vai[1]["vre"]['open']){
            $vai[1]["vre"]['oty'] = 2;   // venta      
        }else{
            $vai[1]["vre"]['oty'] = 0;
        }   
        if($vai[1]["vre"]["oty"] >= 0){
            $emalow = "[" . $vai[1]["vre"]["emalo"] . "," . $vai[2]["vre"]["emalo"] .  "]";
            $emahigh = "[" . $vai[1]["vre"]["emahi"] . "," . $vai[2]["vre"]["emahi"] .  "]";
            $interarry = "[" . $vai[1]["vre"]["interval"] . "," . $vai[2]["vre"]["interval"]  . "]";
            $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["openTime"])/1000)))->format('Y-m-d H:i:s');
            $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($vai[1]["vre"]["closeTime"])/1000)))->format('Y-m-d H:i:s');   
            $emitir = 0;     
            if($vai[1]["vre"]['oty'] === 0){
                $accion = "Mantener"; 
                if($this->CV === 2){
                    //$emitir = ($vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"])?1:0;
                    $emitir = 0;
                    $this->CV = ($vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"])?0:2;
                    $may = ($vai[1]["vre"]["emalo"] > $vai[1]["vre"]["emahi"])?"rompe en V":"menor"; 
                }elseif($this->CV === 1){
                    //$emitir = ($vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"])?1:0;
                    $emitir = 0;                
                    $this->CV = ($vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"])?0:1;   
                    $may = ($vai[1]["vre"]["emalo"] < $vai[1]["vre"]["emahi"])?"rompe en C":"mayor";
                }
            }elseif($vai[1]["vre"]['oty'] === 1){
                $may = "";
                $accion = "Comprar"; 
                $emitir = ($this->CV === 1)?0 :1 ;
                $this->CV = 1;          
            }else{
                $may = "";
                $accion = "Vender"; 
                $emitir = ($this->CV === 2 )?0:1;   
                $this->CV = 2;           
            }
            $tokentel = [
                "fechaope" => $fechaope,
                "fechaclo" => $fechaclo,
                "emalow" => $emalow,
                "emahigh" => $emahigh,            
                "close" => $vai[1]["vre"]['close'],
                "open" => $vai[1]["vre"]['open'],
                "interval" => $interarry ,
                "interlow" => $vai[1]["vre"]["interval"],
                "adx30m" => $vai[1]["vre"]["adx"],
                "adx2h" => $vai[2]["vre"]["adx"],
                "accion" => $accion,
                "may" => $may,
                "tim" => $vai[1]["vre"]["closeTime"]/1000,
                "init" => 0,
                'timezone' => $this->config['timezone'],
                'locale' => $this->config['locale'],
                'telusers' => $this->config['telusers'],
                "resCV" => []
            ];
            $tokentelp = "openTime:". $fechaope . "|closeTime:" . $fechaclo . "|low:" . $emalow . "|high:" . $emahigh . "|adx:" . $vai[1]["vre"]["adx"] .
            "|adx2:" . $vai[2]["vre"]["adx"] ."|close:" .  $vai[1]["vre"]['close'] . "|open:" . $vai[1]["vre"]['open'] . "| interv:"
             . $interarry . "|acción:". $accion . "|emitir:" . $emitir . "|may:" . $may . "|cva:" . $this->CV . chr(10);
             if ($emitir === 1){
                $this->printLog($tokentelp);
             }
             $this->algResp = [
                "CV" => $this->CV,
                "emitir" => $emitir,
                "tokentel" => $tokentel
             ];
        }  
         
    }
    public function getAlgResp(){
        return $this->algResp;
    }
    private function getMdiAdx($json, $interval = '15m')
    {
        $i=0;
        //$json = [];
        if($interval === '15m'){
            print_r($json);
            print(chr(10));
        }

        $time_period = 14;        
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);      
        $retval = [  
            "adx" => 0,   
            "adxa" => 0,             
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "oty" => 0, 
            "interval" =>  $interval           
        ];
    
    
        $i = count($json) - 2;
        $retval["adx"] = (!empty($adx[$i]))?$adx[$i]:0; 
        $retval["adxa"] = (!empty($adx[$i]))?$adx[$i-1]:0;           
        $retval["mdi"] = (!empty($mdi[$i]))?$mdi[$i]:0; 
        $retval["pdi"] = (!empty($pdi[$i]))?$pdi[$i]:0;
        return $retval;
    }   
    private function getEmaAdx($json, $emalo = 5, $emahi = 60, $interval = '30m')
    {
        $i=0;
        //$json = [];
        $time_period = 14;        
        $ema_name = "ema_" . $emalo ;
        $highs = [];
        $lows = [];
        $closes = [];
        $vol_med = 0;
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
            $vol_med = $vol_med + $json[$x]['volact'];
        }
        $adx = trader_adx($highs, $lows, $closes, 14);
        $mdi = trader_minus_di($highs, $lows, $closes, 14);
        $pdi = trader_plus_di($highs, $lows, $closes, 14);   
        $ema_vallo =  trader_ema($closes, $emalo); 
        $ema_valhi =  trader_ema($closes, $emahi);
    
        $retval = [
            "emalo" => 0,
            "emahi" => 0,    
            "adx" => 0,    
            "mdi" => 0, 
            "pdi" => 0,                                                         
            "volmed" => 0,
            "volact" => $json[count($json) - 2]['volact'],
            "open" => $json[count($json) - 2]['open'],    
            "close" => $json[count($json) - 2]['close'],    
            "openTime" => $json[count($json) - 2]['openTime'],            
            "closeTime" => $json[count($json) - 2]['closeTime'],
            "oty" => 0, 
            "interval" =>  $interval           
        ];
        $i = count($json) - 2;
        $retval["emalo"] = (!empty($ema_vallo[$i]))?$ema_vallo[$i]:0;
        $retval["emahi"] = (!empty($ema_valhi[$i]))?$ema_valhi[$i]:0;  
        $retval["adx"] = (!empty($adx[$i]))?$adx[$i]:0;   
        $retval["mdi"] = (!empty($mdi[$i]))?$mdi[$i]:0; 
        $retval["pdi"] = (!empty($pdi[$i]))?$pdi[$i]:0;
        $retval["volmed"] = $vol_med / (($i > 0)?$i:1);
        return $retval;
    }    
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }
}