<?php
namespace App;
class ATRCalculator {
    private $period;
    private $tr = null;
    public function __construct($period) {
        $this->period = $period;
    }

    public function updateorg($high, $low, $close) {
        $rtr = null;
        for ($i = 0; $i < count($high); $i++) {
            if ($i < $this->period) {
                if ($i == 0) {
                    $this->tr[$i] = $high[$i] - $low[$i];
                } else {
                    $previous_close = $close[$i-1];
                    $this->tr[$i] = max($high[$i] - $low[$i], abs($high[$i] - $previous_close), abs($low[$i] - $previous_close));
                }
            } else {
                $prev_tr = $this->tr[$i-1];
                $new_tr = max($high[$i] - $low[$i], abs($high[$i] - $close[$i]), abs($low[$i] - $close[$i]));
                $this->tr[$i] = (($prev_tr * ($this->period - 1) + $new_tr) / $this->period);
            }
            $nro = $this->tr[$i];
            $rotr = floatval(intval($this->tr[$i] * 1000))/1000;
        }
        return  $this->tr;
    }
    public function update($high, $low, $close) {
        for ($i = 0; $i < count($high); $i++) {
            if ($i == 0) {
                $this->tr[$i] = $high[$i] - $low[$i];
            } else {
                $previous_close = $close[$i-1];
                $this->tr[$i] = max($high[$i] - $low[$i], abs($high[$i] - $previous_close), abs($low[$i] - $previous_close));
            }
        }        
        $atr = trader_ema($this->tr, $this->period);
        return  $atr;
    } 
    private function mean($array) {
        return array_sum($array) / count($array);
    }

}
