<?php
namespace App;
use App\ResponseApi;
use App\ATRCalculator;
use App\RsiCalculator;
use App\TrendCalculator;
class AlgoritApi
{
    protected $algResp = [
        "CV" => 0,
        "emitir" => 0,
        "tokentel" => []
    ];
    protected $CV;
    protected $FTP;
    protected $FSL;
    protected $RSI;
    protected $ACT;
    protected $PRO = false;
    /**
     * @var ResponseApi
     */
    protected $apiResponse; 
    /**
     * @var rsiCalculator
     */
    protected $rsiCalculator;
    /**
     * @var atrCalculator
     */
    protected $atrCalculator;
    /**
     * @var trendCalculator
     */
    protected $trendCalculator;    
    protected $config;  
    protected $interval;  
    public function __construct()
    {
        require_once __DIR__ . '/Settings.php';
        $params = new Settings();
        $config = $params->settings['config'];        
        $this->config = $config;
        $this->CV = $config['cv'];
        $this->FTP = $config['atrtp'];
        $this->FSL = $config['atrsl'];
        $this->RSI = $config['rsi']; 
        $this->ACT = $config['act'];
        $this->PRO = $config['proge'];
        $this->interval = $config['interval'];
        $this->apiResponse = new ResponseApi();
        $this->trendCalculator = new TrendCalculator();
    }


    public function getAlgoritRsiMacd()
    {
        $this->rsiCalculator = new RsiCalculator($this->config);
        $factor = 3;
        $pd = 14;
        $highs = [];
        $lows = [];
        $closes = [];
        $this->CV = 0;
        $tp = 0; 
        $sl = 0;
        $potp = 0;
        $posl = 0;
        $result = $this->apiResponse->getPrice(['symbol' => "DOTUSDT"], 0);
        $price = $result["price"];
        $vai = array( 1 => ['interval' => $this->interval,'vre' => []]);
        $adx = 0;   
           for ($i = 1; $i <= 1; $i++) {
            $json = $this->apiResponse->getKlines($vai[$i]['interval']);
        }
        for ($x = 0; $x < count($json); $x++) {
            array_push($highs, $json[$x]["high"]);
            array_push($lows, $json[$x]["low"]);
            array_push($closes, $json[$x]["close"]);
        }
        $idm = $this->array_key_last($json);
        $bands = $this->trendCalculator->getPivotClassic($highs, $lows, $closes, $idm);
        $trend = $bands['tren'];
        $this->rsiCalculator->setRsiMacd($highs, $lows, $closes, $trend);
        $rsimacdp = $this->rsiCalculator->getRsiMacdParm();
        print("isMacdBu:{$rsimacdp['isMacdBu']}" .chr(10));
        //RSI
        $this->RSI = $rsimacdp['rsi'];
        // ATR
        $atrlast = $bands['atr'];
        if($rsimacdp['isRsiOvSellAlg']  === 1 and $rsimacdp['isMacdBu'] === 1 /*and $atrlast > 0*/){
            //isRsiOvSellAlg =<33
            $accion = "Comprar"; 
            $emitir = 1;
            $this->CV = 1;     
            $this->ACT = 1; 
        }elseif($rsimacdp['isRsiOvBuyAlg'] === 1 and $rsimacdp['isMacdBu'] === 0 /*and $atrlast > 0*/){
            //isRsiOvBuyAlg >=66
            $accion = "Vender"; 
            $emitir = 1;   
            $this->CV = 2; 
            $this->ACT = 2;  
        }elseif($rsimacdp['isDoRsiOvSellAlg']  === 1 and $rsimacdp['isMacdBu'] === 1 /*and $atrlast > 0*/){
            //isDoRsiOvSellAlg =< 33
            $accion = "ComprarDo"; 
            $emitir = 1;
            $this->CV = 1;     
            $this->ACT = 11; 
        }elseif($rsimacdp['isDoRsiOvBuyAlg'] === 1 and $rsimacdp['isMacdBu'] === 0 /*and $atrlast > 0*/){
            //isDoRsiOvBuyAlg >=50
            $accion = "VenderDo"; 
            $emitir = 1;   
            $this->CV = 2; 
            $this->ACT = 12;         
        }elseif($rsimacdp['isUpRsiOvSellAlg']  === 1 and $rsimacdp['isMacdBu'] === 1 /*and $atrlast > 0*/){
            //isUpRsiOvSellAlg =<50
            $accion = "ComprarUp"; 
            $emitir = 1;
            $this->CV = 1;     
            $this->ACT = 13; 
        }elseif($rsimacdp['isUpRsiOvBuyAlg'] === 1 and $rsimacdp['isMacdBu'] === 0 /*and $atrlast > 0*/){
            //isUpRsiOvBuyAlg >=67
            $accion = "VenderUp"; 
            $emitir = 1;   
            $this->CV = 2; 
            $this->ACT = 14;
        }else{
            $accion = "Mantener"; 
            $emitir = 0;   
            $this->CV = 0;
            $this->ACT = 0;
            if($this->PRO){
                if($rsimacdp['rsiUp'] === 1 and $rsimacdp['rsi'] >= $rsimacdp['rsian'] and $rsimacdp['treUp'] === 1 and $trend = 'up'){
                    $accion = "Comprar Up7"; 
                    $emitir = 1;
                    $this->CV = 1;
                    $this->ACT = 7; 
                }elseif($rsimacdp['rsiDo'] === 1 and $rsimacdp['rsi'] <= $rsimacdp['rsian'] and $rsimacdp['treDo'] === 1  and $trend = 'do'){
                    $accion = "Vender Do8"; 
                    $emitir = 1;   
                    $this->CV = 2;  
                    $this->ACT = 8; 
                }elseif($rsimacdp['rsiUp'] === 1 and $rsimacdp['rsi'] >= $rsimacdp['rsian'] and $rsimacdp['treUp'] === 0  and $trend = 'up'){
                    $accion = "Comprar Up9"; 
                    $emitir = 1;
                    $this->CV = 1;
                    $this->ACT = 9; 
                }elseif($rsimacdp['rsiDo'] === 1 and $rsimacdp['rsi'] <= $rsimacdp['rsian'] and $rsimacdp['treUp'] === 1  and $trend = 'do'){
                    $accion = "Vender Do10"; 
                    $emitir = 1;   
                    $this->CV = 2;  
                    $this->ACT = 10;                     
                }elseif($rsimacdp['isMacdBu'] === 1  and $rsimacdp['rsiUp'] === 1 and $rsimacdp['rsi'] >= $rsimacdp['rsian'] and $trend = 'up'){
                    $accion = "Comprar Up3"; 
                    $emitir = 1;
                    $this->CV = 1;
                    $this->ACT = 3; 
                }elseif($rsimacdp['isMacdBu'] === 0 and $rsimacdp['rsiDo'] === 1 and $rsimacdp['rsi'] <= $rsimacdp['rsian'] and $trend = 'do'){
                    $accion = "Vender Do4"; 
                    $emitir = 1;   
                    $this->CV = 2;  
                    $this->ACT = 4;
                }elseif($rsimacdp['isMacdBu'] === 1 and $rsimacdp['rsiUp'] === 1 and $rsimacdp['macUp'] === 1  and $rsimacdp['rsi'] >= $rsimacdp['rsian']  and $trend = 'up'){
                    $accion = "Comprar Up5"; 
                    $emitir = 1;
                    $this->CV = 1;
                    $this->ACT = 5; 
                }elseif($rsimacdp['isMacdBu'] === 0 and $rsimacdp['rsiDo'] === 1 and $rsimacdp['macDo'] === 1 and $rsimacdp['rsi'] <= $rsimacdp['rsian']  and $trend = 'do'){
                    $accion = "Vender Do6"; 
                    $emitir = 1;   
                    $this->CV = 2;  
                    $this->ACT = 6; 
                }elseif($rsimacdp['rsiDo'] === 1 and $rsimacdp['rsi'] <= $rsimacdp['rsian'] and $rsimacdp['treDo'] === 1  and $trend = 'do'){
                    $accion = "Comprar Up7"; 
                    $emitir = 1;
                    $this->CV = 1;
                    $this->ACT = 7; 
                }elseif($rsimacdp['rsiUp'] === 1 and $rsimacdp['rsi'] >=$rsimacdp['rsian'] and $rsimacdp['treUp'] === 1  and $trend = 'up'){
                    $accion = "Vender Do8"; 
                    $emitir = 1;   
                    $this->CV = 2;  
                    $this->ACT = 8;                     
                }else{
                    $accion = "Mantener"; 
                    $emitir = 0;   
                    $this->CV = 0;
                    $this->ACT = 0;   
                } 
            }
        };
        //quitar desde aqui
        //$accion = "Comprar Up3"; 
        //$emitir = 1;
        //$this->CV = 1;
        //$this->ACT = 3; 
        //quitar hasta aqui
        $tokentel = $this->setTokenTel($json[$idm],$bands,$vai[1], $this->RSI, $accion, $this->ACT);
        if($this->CV === 1){
            //$tp = $bands['r1'] - 0.005; 
            //$sl = $bands['s1'] - 0.005;
            //calculos por ATR- Largo
            $tp = ($price + ($this->FTP * $atrlast));
            $sl = ($price - ($this->FSL * $atrlast));
            $potp = round(((100 - ($tp * 100)/$price)*-1),2);
            $posl = round(((100 - ($sl * 100)/$price)*1),2);
            //calculo resistencia/soporte
            /*
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
            }elseif($potp > 0.8){
                $potp = 0.8;
            }
            $posl = $potp * 2;
            */
            //calculo ATR
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
                $posl = $potp * 2;
            }
            $tokentel["potp"] = $potp;
            $tokentel["posl"] = $posl; 
            $this->printLog("Tp/Sl - compra:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
            if($tp <= $price or $sl >= $price or $potp <= 0 or $posl <= 0){                             
                $emitir = 0;
                $accion = "Mantener Dif.";
                //$tokentel["accion"] = $accion;
            }
        }elseif($this->CV === 2){
            //$tp = $bands['s1'] + 0.005;
            //$sl = $bands['r1'] + 0.005;
            //calculos por ATR - corto
            $tp = ($price - ($this->FTP * $atrlast));
            $sl = ($price + ($this->FSL * $atrlast));
            $potp = round(((100 - ($tp * 100)/$price)*1),2);
            $posl = round(((100 - ($sl * 100)/$price)*-1),2);
            //calculo resistencia/soporte
            /*
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
            }elseif($potp > 0.8){
                $potp = 0.8;
            }
            $posl = $potp * 2;
            */
            //calculo ATR
            if($potp > 0 and $potp < 0.4){
                $potp = 0.4;
                $posl = $potp * 2;
            }
            $tokentel["potp"] = $potp;
            $tokentel["posl"] = $posl;
            $this->printLog("Tp/Sl - venta:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));        
            if($tp >= $price or $sl <= $price  or $potp <= 0 or $posl <= 0){
                $emitir = 0;
                $accion = "Mantener Dif.";
            }
        }
        $him = $highs[$idm] > $sl?" >":" <=";
        $tp = round($price -  (($price * $potp) / 100),3);
        $sl = round($price +  (($price * $posl) / 100),3);  
        $this->algResp = [
            "CV" => $this->CV,
            "emitir" => $emitir,
            "tokentel" => $tokentel,
            "rsi" => $this->RSI,
            "act" => $this->ACT
        ];
    }

    public function getAlgResp(){
        return $this->algResp;
    }

    private function array_key_last(array $arr) {
        $i = 0;
        foreach($arr as $key  => $unused) {
            $i = $i +1;
            //return $key;
        }
        return $key;
    }
    private function array_key_first(array $arr) {
        foreach($arr as $key => $unused) {
            return $key;
        }
        return NULL;
    }    
    private function printLog($from){
        $date = (new \DateTime('now'))->format('Y-m-d H:i:s');
        print( "Now: " . $date . "|" . $from );
    }
    private function setTokenTel($json,$bands,$vai,$rsi,$accion, $act){
        $fechaope = (new \DateTime(date('m/d/Y H:i:s',intval($json["openTime"])/1000)))->format('Y-m-d H:i:s');
        $fechaclo = (new \DateTime(date('m/d/Y H:i:s',intval($json["closeTime"])/1000)))->format('Y-m-d H:i:s');
        $interarry = "[" . $vai["interval"]  . "]";
        $tokentel = [
            "fechaope" => $fechaope,
            "fechaclo" => $fechaclo,
            "support" => $bands['supo'],
            "resistance" => $bands['resi'],   
            "potp" => 0,
            "posl" => 0,
            "rsi" => $rsi,
            "act" => $act,
            "close" => $json['close'],
            "open" => $json['open'],
            "interval" => $interarry,
            "interlow" => $vai["interval"],
            "trail" => $bands['trai'],
            "trend" => $bands['tren'],
            "accion" => $accion,
            "may" => '',
            "tim" => $json["closeTime"]/1000,
            "init" => 0,
            'timezone' => $this->config['timezone'],
            'locale' => $this->config['locale'],
            'telusers' => $this->config['telusers'],
            'algorit' => $this->config['algorit'],
            "resCV" => []
        ];
        return $tokentel;
    }
    private function testTpSl($price,$atrlast){
        print("atrlast:{$atrlast} ftp:{$this->FTP} fsl:{$this->FSL}" .chr(10));
        //Test de ATR
        //calculos por ATR para compras
        $tp = ($price + ($this->FTP * $atrlast));
        $sl = ($price - ($this->FSL * $atrlast));
        $potp = round(((100 - ($tp * 100)/$price)*-1),2);
        $posl = round(((100 - ($sl * 100)/$price)*1),2);
        $this->printLog("Tp/Sl - compra:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        //calculos por ATR para ventas
        $tp = ($price - ($this->FTP * $atrlast));
        $sl = ($price + ($this->FSL * $atrlast));
        $potp = round(((100 - ($tp * 100)/$price)*1),2);
        $posl = round(((100 - ($sl * 100)/$price)*-1),2);
        $this->printLog("Tp/Sl - venta:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        //Test de Soporte/Resistencia
        print("soporte:{$bands['s1']} resistencia:{$bands['r1']}" .chr(10));
        //calculos por SR para compras
        $tp = $bands['r1'] - 0.005; 
        $sl = $bands['s1'] - 0.005;
        $potp = round(((100 - ($tp * 100)/$price)*-1),2);
        $posl = round(((100 - ($sl * 100)/$price)*1),2);
        $this->printLog("Tp/Sl - compra:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));
        //calculos por SR para ventas
        $tp = $bands['s1'] + 0.005;
        $sl = $bands['r1'] + 0.005;
        $potp = round(((100 - ($tp * 100)/$price)*1),2);
        $posl = round(((100 - ($sl * 100)/$price)*-1),2);
        $this->printLog("Tp/Sl - venta:{$price} tp:{$tp} sl:{$sl} portp:" . $potp . " porsl:" . $posl . chr(10));        
    }
}
